/*
 * Decompiled with CFR 0.152.
 */
package net.trajano.ms.vertx.test;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.module.jaxb.JaxbAnnotationModule;
import io.vertx.core.http.HttpServerOptions;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.URI;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;

@Configuration
public class TestConfig {
    @Bean
    public URI baseUri(@Qualifier(value="server.port") int httpPort) {
        return URI.create("http://localhost:" + httpPort);
    }

    @Bean
    public ObjectMapper objectMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.registerModule((Module)new JaxbAnnotationModule());
        return objectMapper;
    }

    @Bean
    @Primary
    public HttpServerOptions serverOptions(@Qualifier(value="server.port") int httpPort) {
        return new HttpServerOptions().setPort(httpPort);
    }

    @Bean
    @Qualifier(value="server.port")
    public int serverPort() throws IOException {
        try (ServerSocket s = new ServerSocket(0);){
            int n = s.getLocalPort();
            return n;
        }
    }
}

