/*
 * Decompiled with CFR 0.152.
 */
package net.trajano.ms.vertx.test;

import com.google.gson.JsonObject;
import io.vertx.core.Vertx;
import io.vertx.core.http.HttpClient;
import io.vertx.core.http.HttpClientOptions;
import java.net.URI;
import java.util.Map;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.core.Form;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import net.trajano.ms.engine.internal.resteasy.VertxClientEngine;
import net.trajano.ms.sample.MyApp;
import net.trajano.ms.spi.MicroserviceEngine;
import net.trajano.ms.vertx.VertxConfig;
import net.trajano.ms.vertx.jaxrs.GsonMessageBodyHandler;
import net.trajano.ms.vertx.test.MicroserviceTestUtil;
import org.jboss.resteasy.client.jaxrs.ClientHttpEngine;
import org.jboss.resteasy.client.jaxrs.ResteasyClient;
import org.jboss.resteasy.client.jaxrs.ResteasyClientBuilder;
import org.jboss.resteasy.spi.ResteasyDeployment;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.test.context.junit4.SpringRunner;

@RunWith(value=SpringRunner.class)
@SpringBootTest(classes={VertxConfig.class})
public class SpringJaxrsHandlerTest {
    @Autowired
    private URI baseUri;
    @Autowired
    private MicroserviceEngine engine;
    @Autowired
    private HttpClientOptions httpClientOptions;

    @BeforeClass
    public static void setApplication() {
        MicroserviceTestUtil.setApplicationClass(MyApp.class);
    }

    @Test
    public void testAsync() {
        Assert.assertNotNull((Object)this.engine);
        Response response = ClientBuilder.newClient().target(this.baseUri).path("/api/hello/async").request().get();
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Assert.assertTrue((boolean)((String)response.readEntity(String.class)).startsWith("{"));
    }

    @Test
    public void testEngine() {
        Assert.assertNotNull((Object)this.engine);
        Response response = ClientBuilder.newClient().target(this.baseUri).path("/api/sing").request().get();
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Assert.assertTrue((boolean)((String)response.readEntity(String.class)).startsWith("Hello"));
    }

    @Test
    public void testEngineWithInjectedClient() {
        HttpClient httpClient = Vertx.vertx().createHttpClient(this.httpClientOptions);
        ResteasyClient client = new ResteasyClientBuilder().httpEngine((ClientHttpEngine)new VertxClientEngine(httpClient)).build();
        Response response = client.target(this.baseUri).path("/api/sing").request().get();
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Assert.assertTrue((boolean)((String)response.readEntity(String.class)).startsWith("Hello"));
    }

    @Test
    public void testEngineWithInjectedClient400() {
        HttpClient httpClient = Vertx.vertx().createHttpClient(this.httpClientOptions);
        ResteasyClient client = new ResteasyClientBuilder().httpEngine((ClientHttpEngine)new VertxClientEngine(httpClient)).build();
        Response response = client.target("https://httpbin.org/status/400").request().get();
        Assert.assertEquals((long)400L, (long)response.getStatus());
    }

    @Test(expected=BadRequestException.class)
    public void testEngineWithInjectedClient400ViaException() {
        HttpClient httpClient = Vertx.vertx().createHttpClient(this.httpClientOptions);
        ResteasyClient client = new ResteasyClientBuilder().httpEngine((ClientHttpEngine)new VertxClientEngine(httpClient)).build();
        client.target("https://httpbin.org/status/400").request().get(Map.class);
    }

    @Test
    public void testEngineWithInjectedClientPost() {
        HttpClient httpClient = Vertx.vertx().createHttpClient(this.httpClientOptions);
        ResteasyClient client = new ResteasyClientBuilder().httpEngine((ClientHttpEngine)new VertxClientEngine(httpClient)).register(GsonMessageBodyHandler.class).build();
        Form xform = new Form();
        xform.param("userName", "ca1\\\\meowmix");
        xform.param("password", "mingnamulan");
        xform.param("state", "authenticate");
        xform.param("style", "xml");
        xform.param("xsl", "none");
        JsonObject arsString = (JsonObject)client.target("https://httpbin.org/post").request().post(Entity.form((Form)xform), JsonObject.class);
        Assert.assertEquals((Object)"xml", (Object)arsString.getAsJsonObject("form").get("style").getAsString());
    }

    @Test
    public void testEngineWithInjectedClientPost2() {
        ResteasyDeployment deployment = new ResteasyDeployment();
        deployment.start();
        ResteasyProviderFactory providerFactory = deployment.getProviderFactory();
        HttpClient httpClient = Vertx.vertx().createHttpClient(this.httpClientOptions);
        ResteasyClient client = new ResteasyClientBuilder().providerFactory(providerFactory).httpEngine((ClientHttpEngine)new VertxClientEngine(httpClient)).register(GsonMessageBodyHandler.class).build();
        Form xform = new Form();
        xform.param("userName", "ca1\\\\meowmix");
        xform.param("password", "mingnamulan");
        xform.param("state", "authenticate");
        xform.param("style", "xml");
        xform.param("xsl", "none");
        Response response = (Response)client.target("https://httpbin.org/post").request(new String[]{"application/json"}).post(Entity.form((Form)xform), Response.class);
        Assert.assertFalse((boolean)response.getStringHeaders().isEmpty());
        System.out.println(response.getStringHeaders());
        Assert.assertFalse((boolean)response.getHeaders().isEmpty());
        Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)response.getMediaType());
        Assert.assertTrue((boolean)response.hasEntity());
        JsonObject arsString = (JsonObject)response.readEntity(JsonObject.class);
        Assert.assertEquals((Object)"xml", (Object)arsString.getAsJsonObject("form").get("style").getAsString());
    }
}

