/*
 * Decompiled with CFR 0.152.
 */
package net.trajano.ms.vertx.test;

import net.trajano.ms.sample.JwksResource;
import net.trajano.ms.vertx.VertxConfig;
import net.trajano.ms.vertx.beans.CachedDataProvider;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.test.context.junit4.SpringRunner;

@RunWith(value=SpringRunner.class)
@SpringBootTest(classes={VertxConfig.class})
public class CacheCreationTest {
    @Autowired
    private CachedDataProvider cachedDataProvider;

    @Test
    public void springConcurrentMapCacheManagerTest() throws Exception {
        Assert.assertNotNull((Object)this.cachedDataProvider);
    }

    @Test
    public void testJwksResource() throws Exception {
        JwksResource jwksResource = new JwksResource();
        jwksResource.setCachedDataProvider(this.cachedDataProvider);
        System.out.println(jwksResource.getPublicKeySet());
    }

    @Test
    public void testNonce() throws Exception {
        String nonce = this.cachedDataProvider.newNonce();
        Assert.assertNotNull((Object)nonce);
        Assert.assertTrue((boolean)this.cachedDataProvider.claimNonce(nonce));
        Assert.assertFalse((boolean)this.cachedDataProvider.claimNonce(nonce));
    }

    @Test
    public void testProvider() throws Exception {
        Assert.assertNotNull((Object)this.cachedDataProvider.getKeySet());
        Assert.assertEquals((long)2L, (long)this.cachedDataProvider.getKeySet().getJsonWebKeys().size());
    }
}

