/*
 * Decompiled with CFR 0.152.
 */
package net.trajano.ms.vertx.jaxrs;

import io.vertx.ext.web.RoutingContext;
import java.io.IOException;
import javax.annotation.Priority;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.PreMatching;
import javax.ws.rs.core.Context;
import javax.ws.rs.ext.Provider;
import org.slf4j.MDC;
import org.springframework.stereotype.Component;

@Component
@Provider
@Priority(value=2001)
@PreMatching
public class RequestIdContextInterceptor
implements ContainerRequestFilter {
    public static final String REQUEST_ID = "X-Request-ID";
    @Context
    private RoutingContext routingContext;

    public void filter(ContainerRequestContext requestContext) throws IOException {
        String requestID = requestContext.getHeaderString(REQUEST_ID);
        if (requestID != null) {
            MDC.put((String)REQUEST_ID, (String)requestID);
        }
    }
}

