/*
 * Decompiled with CFR 0.152.
 */
package net.trajano.ms.vertx.jaxrs;

import javax.annotation.Priority;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.ext.Provider;
import net.trajano.ms.spi.MicroserviceEngine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@Provider
@Priority(value=2000)
public class MDCInterceptor
implements ContainerRequestFilter {
    private static final Logger LOG = LoggerFactory.getLogger(MDCInterceptor.class);
    @Autowired
    private MicroserviceEngine engine;

    public void filter(ContainerRequestContext requestContext) {
        MDC.put((String)"X-Request-ID", (String)requestContext.getHeaderString("X-Request-ID"));
        if (LOG.isDebugEnabled()) {
            MDC.put((String)"X-Request-Method", (String)requestContext.getMethod());
            MDC.put((String)"X-Request-URI", (String)requestContext.getUriInfo().getRequestUri().toASCIIString());
            MDC.put((String)"Host", (String)(this.engine.hostname() + ":" + this.engine.port()));
        }
    }
}

