/*
 * Decompiled with CFR 0.152.
 */
package net.trajano.ms.vertx.jaxrs;

import java.net.URI;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.PostConstruct;
import javax.annotation.Priority;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.ResourceInfo;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.ext.Provider;
import net.trajano.ms.core.ErrorResponse;
import net.trajano.ms.vertx.beans.CachedDataProvider;
import net.trajano.ms.vertx.beans.DefaultAssertionRequiredPredicate;
import net.trajano.ms.vertx.beans.JwtAssertionRequiredPredicate;
import net.trajano.ms.vertx.beans.JwtClaimsProcessor;
import net.trajano.ms.vertx.jaxrs.JwtSecurityContext;
import org.jose4j.jwk.HttpsJwks;
import org.jose4j.jwt.JwtClaims;
import org.jose4j.jwt.MalformedClaimException;
import org.jose4j.jwt.consumer.InvalidJwtException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
@Provider
@Priority(value=2001)
public class JwtAssertionInterceptor
implements ContainerRequestFilter {
    private static final Logger LOG = LoggerFactory.getLogger(JwtAssertionInterceptor.class);
    public static final String X_JWKS_URI = "X-JWKS-URI";
    public static final String X_JWT_ASSERTION = "X-JWT-Assertion";
    public static final String X_JWT_AUDIENCE = "X-JWT-Audience";
    private JwtAssertionRequiredPredicate assertionRequiredPredicate;
    private CachedDataProvider cachedDataProvider;
    private JwtClaimsProcessor claimsProcessor;
    @Autowired(required=false)
    @Qualifier(value="authz.issuer")
    private URI issuer;
    private final ConcurrentMap<String, HttpsJwks> jwks = new ConcurrentHashMap<String, HttpsJwks>();
    @Context
    private ResourceInfo resourceInfo;

    public void filter(ContainerRequestContext requestContext) {
        JwtClaims claims;
        if (!this.assertionRequiredPredicate.test(this.resourceInfo)) {
            return;
        }
        String assertion = requestContext.getHeaderString(X_JWT_ASSERTION);
        if (assertion == null) {
            LOG.warn("Missing assertion on request for {}", (Object)requestContext.getUriInfo());
            requestContext.abortWith(Response.status((Response.Status)Response.Status.UNAUTHORIZED).header("WWW-Authenticate", (Object)X_JWT_ASSERTION).entity((Object)new ErrorResponse("unauthorized_client", "Missing assertion")).build());
            return;
        }
        LOG.debug("assertion={}", (Object)assertion);
        try {
            HttpsJwks httpsJwks;
            String jwksUri = requestContext.getHeaderString(X_JWKS_URI);
            if (jwksUri == null) {
                httpsJwks = null;
            } else {
                httpsJwks = (HttpsJwks)this.jwks.get(jwksUri);
                if (httpsJwks == null) {
                    httpsJwks = new HttpsJwks(jwksUri);
                }
            }
            List<String> audience = Arrays.asList(requestContext.getHeaderString(X_JWT_AUDIENCE).split(", "));
            claims = this.cachedDataProvider.buildConsumer(httpsJwks, audience).processToClaims(assertion);
            MDC.put((String)"X-JWT-ID", (String)claims.getJwtId());
        }
        catch (MalformedClaimException | InvalidJwtException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("JWT invalid", e);
            } else {
                LOG.error("JWT Invalid");
            }
            requestContext.abortWith(Response.status((Response.Status)Response.Status.UNAUTHORIZED).header("WWW-Authenticate", (Object)X_JWT_ASSERTION).entity((Object)new ErrorResponse("unauthorized_client", "JWT was not valid")).build());
            return;
        }
        requestContext.setSecurityContext((SecurityContext)new JwtSecurityContext(claims, requestContext.getUriInfo()));
        if (this.claimsProcessor != null) {
            boolean validateClaims = (Boolean)this.claimsProcessor.apply(claims);
            LOG.debug("{}.validateClaims result={}", (Object)this.claimsProcessor, (Object)validateClaims);
            if (!validateClaims) {
                LOG.warn("Validation of claims failed on request for {}", (Object)requestContext.getUriInfo());
                requestContext.abortWith(Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)new ErrorResponse("forbidden", "Claims validation failed")).build());
            }
        }
    }

    @PostConstruct
    public void init() {
        if (this.issuer == null) {
            LOG.warn("`authz.issuer` was not specified, will accept any issuer");
        }
        if (this.claimsProcessor == null) {
            LOG.warn("JwtClaimsProcessor was not defined, will not peform any claims validation");
        }
        if (this.assertionRequiredPredicate == null) {
            LOG.debug("assertionRequiredPredicate was not defined, default annotation based predicate will be used");
            this.assertionRequiredPredicate = new DefaultAssertionRequiredPredicate();
        }
    }

    @Autowired(required=false)
    public void setAssertionRequiredFunction(JwtAssertionRequiredPredicate predicate) {
        this.assertionRequiredPredicate = predicate;
    }

    @Autowired
    public void setCachedDataProvider(CachedDataProvider cachedDataProvider) {
        this.cachedDataProvider = cachedDataProvider;
    }

    @Autowired(required=false)
    public void setClaimsProcessor(JwtClaimsProcessor claimsProcessor) {
        this.claimsProcessor = claimsProcessor;
    }

    public void setResourceInfo(ResourceInfo resourceInfo) {
        this.resourceInfo = resourceInfo;
    }
}

