/*
 * Decompiled with CFR 0.152.
 */
package net.trajano.ms.vertx.jaxrs;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.ws.rs.ClientErrorException;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;
import net.trajano.ms.core.ErrorResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;
import org.springframework.stereotype.Component;

@Configuration
@Component
@Provider
@Produces(value={"application/json", "application/xml", "text/xml", "text/plain"})
public class JsonExceptionMapper
implements ExceptionMapper<Throwable> {
    private static final Logger LOG = LoggerFactory.getLogger(JsonExceptionMapper.class);
    private static final Set<MediaType> SUPPORTED_MEDIA_TYPES = new HashSet<MediaType>(Arrays.asList(MediaType.APPLICATION_JSON_TYPE, MediaType.APPLICATION_XML_TYPE, MediaType.TEXT_XML_TYPE, MediaType.TEXT_PLAIN_TYPE, MediaType.TEXT_HTML_TYPE));
    @Context
    private HttpHeaders headers;
    @Value(value="${microservice.show_stack_trace:#{null}}")
    private Boolean showStackTrace;
    @Context
    private UriInfo uriInfo;

    private MediaType getAppropriateMediaType() {
        List acceptableMediaTypes = this.headers.getAcceptableMediaTypes();
        for (MediaType mediaType : acceptableMediaTypes) {
            if (mediaType.equals((Object)MediaType.WILDCARD_TYPE)) {
                return MediaType.APPLICATION_JSON_TYPE;
            }
            if (!SUPPORTED_MEDIA_TYPES.contains(mediaType)) continue;
            return mediaType;
        }
        return MediaType.APPLICATION_JSON_TYPE;
    }

    private void log(Throwable exception) {
        if (exception instanceof ClientErrorException) {
            if (!(exception instanceof NotFoundException)) {
                LOG.warn("uri={} message={}", new Object[]{this.uriInfo.getRequestUri(), exception.getMessage(), exception});
            }
        } else {
            LOG.error("uri={} message={}", new Object[]{this.uriInfo.getRequestUri(), exception.getMessage(), exception});
        }
    }

    public void setContextData(HttpHeaders headers, UriInfo uriInfo, boolean showStackTrace) {
        this.headers = headers;
        this.uriInfo = uriInfo;
        this.showStackTrace = showStackTrace;
    }

    @PostConstruct
    public void setDebugFlags() {
        if (this.showStackTrace == null) {
            this.showStackTrace = LOG.isDebugEnabled();
            LOG.debug("stack trace enabled if this is shown");
        }
    }

    public Response toResponse(Throwable exception) {
        MediaType mediaType;
        this.log(exception);
        int status = Response.Status.INTERNAL_SERVER_ERROR.getStatusCode();
        if (exception instanceof WebApplicationException) {
            WebApplicationException internalException = (WebApplicationException)exception;
            if (internalException.getResponse().hasEntity()) {
                return internalException.getResponse();
            }
            status = internalException.getResponse().getStatus();
        }
        if ((mediaType = this.getAppropriateMediaType()).isCompatible(MediaType.TEXT_PLAIN_TYPE) || mediaType.isCompatible(MediaType.TEXT_HTML_TYPE)) {
            return Response.status((int)status).entity((Object)exception.getMessage()).type(mediaType).build();
        }
        return Response.status((int)status).entity((Object)new ErrorResponse(exception, this.uriInfo, this.showStackTrace.booleanValue())).type(mediaType).build();
    }
}

