/*
 * Decompiled with CFR 0.152.
 */
package net.trajano.ms.vertx.jaxrs;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import javax.ws.rs.Consumes;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;
import org.springframework.stereotype.Component;

@Component
@Provider
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public final class GsonMessageBodyHandler
implements MessageBodyWriter<JsonElement>,
MessageBodyReader<JsonElement> {
    private final Gson gson = new GsonBuilder().create();

    public long getSize(JsonElement t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return -1L;
    }

    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return true;
    }

    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return true;
    }

    public JsonElement readFrom(Class<JsonElement> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException {
        try (InputStreamReader r = new InputStreamReader(entityStream, StandardCharsets.UTF_8);){
            JsonElement jsonElement = (JsonElement)this.gson.fromJson((Reader)r, JsonElement.class);
            return jsonElement;
        }
    }

    public void writeTo(JsonElement t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException {
        try (OutputStreamWriter w = new OutputStreamWriter(entityStream);){
            this.gson.toJson(t, new JsonWriter((Writer)w));
        }
    }
}

