/*
 * Decompiled with CFR 0.152.
 */
package net.trajano.ms.vertx.beans;

import java.security.Key;
import javax.ws.rs.InternalServerErrorException;
import net.trajano.ms.core.CryptoOps;
import net.trajano.ms.vertx.beans.CachedDataProvider;
import net.trajano.ms.vertx.beans.TokenGenerator;
import org.jose4j.jwk.HttpsJwks;
import org.jose4j.jwk.RsaJsonWebKey;
import org.jose4j.jws.JsonWebSignature;
import org.jose4j.jwt.JwtClaims;
import org.jose4j.jwt.consumer.InvalidJwtException;
import org.jose4j.jwt.consumer.JwtConsumer;
import org.jose4j.jwt.consumer.JwtConsumerBuilder;
import org.jose4j.keys.resolvers.HttpsJwksVerificationKeyResolver;
import org.jose4j.keys.resolvers.VerificationKeyResolver;
import org.jose4j.lang.JoseException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class JcaCryptoOps
implements CryptoOps {
    @Autowired
    private CachedDataProvider cachedDataProvider;
    @Autowired
    private TokenGenerator tokenGenerator;

    public String newToken() {
        return this.tokenGenerator.newToken();
    }

    public String sign(JwtClaims claims) {
        try {
            RsaJsonWebKey aSigningKey = this.cachedDataProvider.getASigningKey();
            JsonWebSignature jws = new JsonWebSignature();
            jws.setPayload(claims.toJson());
            jws.setKeyIdHeaderValue(aSigningKey.getKeyId());
            jws.setKey((Key)aSigningKey.getPrivateKey());
            jws.setAlgorithmHeaderValue(aSigningKey.getAlgorithm());
            jws.sign();
            return jws.getCompactSerialization();
        }
        catch (JoseException e) {
            throw new InternalServerErrorException((Throwable)e);
        }
    }

    public JwtClaims toClaimsSet(String jwt, String audience, HttpsJwks httpsJwks) {
        JwtConsumerBuilder builder = new JwtConsumerBuilder().setVerificationKeyResolver((VerificationKeyResolver)new HttpsJwksVerificationKeyResolver(httpsJwks));
        if (audience == null) {
            builder.setSkipDefaultAudienceValidation();
        } else {
            builder.setExpectedAudience(new String[]{audience});
        }
        JwtConsumer jwtConsumer = builder.build();
        try {
            return jwtConsumer.processToClaims(jwt);
        }
        catch (InvalidJwtException e) {
            throw new InternalServerErrorException((Throwable)e);
        }
    }
}

