/*
 * Decompiled with CFR 0.152.
 */
package net.trajano.ms.vertx.beans;

import java.lang.reflect.Method;
import javax.annotation.security.PermitAll;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.container.ResourceInfo;
import net.trajano.ms.vertx.beans.JwtAssertionRequiredPredicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultAssertionRequiredPredicate
implements JwtAssertionRequiredPredicate {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultAssertionRequiredPredicate.class);

    @Override
    public boolean test(ResourceInfo resourceInfo) {
        boolean resourceClassHasPermitAll;
        Method resourceMethod = resourceInfo.getResourceMethod();
        Class resourceClass = resourceInfo.getResourceClass();
        boolean resourceMethodHasRolesAllowed = resourceMethod.getAnnotation(RolesAllowed.class) != null;
        boolean resourceClassHasRolesAllowed = resourceClass.getAnnotation(RolesAllowed.class) != null;
        boolean resourceMethodHasPermitAll = resourceMethod.getAnnotation(PermitAll.class) != null;
        boolean bl = resourceClassHasPermitAll = resourceClass.getAnnotation(PermitAll.class) != null;
        if (LOG.isDebugEnabled()) {
            LOG.debug("resourceMethod={} PermitAll={} RolesAllowed={}", new Object[]{resourceMethod, resourceMethodHasPermitAll, resourceMethodHasRolesAllowed});
            LOG.debug("resourceClass={} PermitAll={} RolesAllowed={}", new Object[]{resourceClass, resourceClassHasPermitAll, resourceClassHasRolesAllowed});
        }
        if (resourceMethodHasRolesAllowed && resourceMethodHasPermitAll) {
            throw new IllegalArgumentException("The resource method " + resourceMethod + " may not have both @RolesAllowed and @PermitAll annotations.");
        }
        if (resourceClassHasRolesAllowed && resourceClassHasPermitAll) {
            throw new IllegalArgumentException("The resource class " + resourceClass + " may not have both @RolesAllowed and @PermitAll annotations.");
        }
        return !(!resourceMethodHasRolesAllowed && !resourceClassHasRolesAllowed && resourceClassHasPermitAll || !resourceMethodHasRolesAllowed && resourceMethodHasPermitAll);
    }
}

