/*
 * Decompiled with CFR 0.152.
 */
package net.trajano.ms.vertx.beans;

import java.util.List;
import javax.annotation.PostConstruct;
import javax.ws.rs.InternalServerErrorException;
import net.trajano.ms.core.NonceOps;
import net.trajano.ms.vertx.beans.TokenGenerator;
import org.jose4j.jwk.HttpsJwks;
import org.jose4j.jwk.JsonWebKey;
import org.jose4j.jwk.JsonWebKeySet;
import org.jose4j.jwk.RsaJsonWebKey;
import org.jose4j.jwk.RsaJwkGenerator;
import org.jose4j.jwt.consumer.JwtConsumer;
import org.jose4j.jwt.consumer.JwtConsumerBuilder;
import org.jose4j.keys.resolvers.HttpsJwksVerificationKeyResolver;
import org.jose4j.keys.resolvers.VerificationKeyResolver;
import org.jose4j.lang.JoseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.Cache;
import org.springframework.cache.CacheManager;
import org.springframework.cache.concurrent.ConcurrentMapCacheManager;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
public class CachedDataProvider
implements NonceOps {
    private static final Logger LOG = LoggerFactory.getLogger(CachedDataProvider.class);
    public static final int MAX_NUMBER_OF_KEYS = 5;
    public static final int MIN_NUMBER_OF_KEYS = 2;
    @Autowired(required=false)
    private CacheManager cm;
    private Cache jwksCache;
    private Cache nonceCache;
    @Autowired
    private TokenGenerator tokenGenerator;

    public JwtConsumer buildConsumer() {
        return this.buildConsumer(null, null);
    }

    public JwtConsumer buildConsumer(HttpsJwks jwks, List<String> audience) {
        JwtConsumerBuilder builder = new JwtConsumerBuilder().setRequireJwtId();
        if (jwks != null) {
            builder.setVerificationKeyResolver((VerificationKeyResolver)new HttpsJwksVerificationKeyResolver(jwks));
        } else {
            builder.setSkipSignatureVerification();
        }
        if (audience != null) {
            builder.setExpectedAudience(audience.toArray(new String[audience.size()]));
        } else {
            builder.setSkipDefaultAudienceValidation();
        }
        return builder.build();
    }

    @Scheduled(fixedDelay=60000L)
    public void buildJwks() {
        int nCreated = 0;
        for (int i = 0; i < 5; ++i) {
            String cacheKey = String.valueOf(i);
            JsonWebKey jwk = (JsonWebKey)this.jwksCache.get((Object)cacheKey, JsonWebKey.class);
            if (jwk != null || nCreated >= 2) continue;
            RsaJsonWebKey newJwk = this.buildNewRsaKey();
            this.jwksCache.putIfAbsent((Object)cacheKey, (Object)newJwk);
            ++nCreated;
            LOG.debug("Created new JWK kid={}", (Object)newJwk.getKeyId());
        }
    }

    private RsaJsonWebKey buildNewRsaKey() {
        try {
            RsaJsonWebKey rsaJsonWebKey = RsaJwkGenerator.generateJwk((int)2048);
            rsaJsonWebKey.setKeyId(this.tokenGenerator.newToken());
            rsaJsonWebKey.setAlgorithm("RS512");
            rsaJsonWebKey.setUse("sig");
            return rsaJsonWebKey;
        }
        catch (JoseException e) {
            throw new InternalServerErrorException((Throwable)e);
        }
    }

    public boolean claimNonce(String nonce) {
        Boolean value = (Boolean)this.nonceCache.get((Object)nonce, Boolean.class);
        if (value == null) {
            return false;
        }
        this.nonceCache.evict((Object)nonce);
        return value;
    }

    public RsaJsonWebKey getASigningKey() {
        JsonWebKeySet keySet = this.getKeySet();
        if (LOG.isDebugEnabled()) {
            LOG.debug(keySet.toJson());
        }
        return (RsaJsonWebKey)keySet.findJsonWebKey(null, "RSA", "sig", null);
    }

    private Cache getCache(String cacheName) {
        Cache cache = this.cm.getCache("jwks_cache");
        if (cache == null) {
            LOG.warn("A no cache named {} was not provided by the cache manager an in-memory cache will be used", (Object)cacheName);
            cache = new ConcurrentMapCacheManager(new String[]{cacheName}).getCache(cacheName);
        }
        return cache;
    }

    public JsonWebKeySet getKeySet() {
        JsonWebKeySet set = new JsonWebKeySet(new JsonWebKey[0]);
        for (int i = 0; i < 5; ++i) {
            String cacheKey = String.valueOf(i);
            JsonWebKey jwk = (JsonWebKey)this.jwksCache.get((Object)cacheKey, JsonWebKey.class);
            if (jwk == null) continue;
            set.addJsonWebKey(jwk);
        }
        return set;
    }

    @PostConstruct
    public void init() {
        if (this.cm == null) {
            LOG.warn("A org.springframework.cache.CacheManager was not provided an in-memory cache will be used");
            this.cm = new ConcurrentMapCacheManager(new String[]{"jwks_cache", "nonce"});
        }
        this.jwksCache = this.getCache("jwks_cache");
        this.nonceCache = this.getCache("nonce");
        LOG.debug("jwksCache={} nonceCache={}", (Object)this.jwksCache, (Object)this.nonceCache);
        this.buildJwks();
    }

    public String newNonce() {
        String nonce = this.tokenGenerator.newToken();
        this.nonceCache.putIfAbsent((Object)nonce, (Object)true);
        return nonce;
    }
}

