/*
 * Decompiled with CFR 0.152.
 */
package net.trajano.ms.vertx;

import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.VertxOptions;
import io.vertx.core.http.HttpServer;
import io.vertx.core.http.HttpServerOptions;
import io.vertx.ext.web.Router;
import java.io.File;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Deque;
import java.util.LinkedList;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.ws.rs.core.Response;
import net.trajano.ms.Microservice;
import net.trajano.ms.engine.ManifestHandler;
import net.trajano.ms.engine.SpringJaxRsHandler;
import net.trajano.ms.engine.SwaggerHandler;
import net.trajano.ms.engine.jaxrs.JaxRsRouter;
import net.trajano.ms.engine.jaxrs.PathsProvider;
import net.trajano.ms.spi.MicroserviceEngine;
import net.trajano.ms.vertx.VertxConfig;
import net.trajano.ms.vertx.beans.CachedDataProvider;
import net.trajano.ms.vertx.beans.GsonJacksonJsonOps;
import net.trajano.ms.vertx.beans.GsonProvider;
import net.trajano.ms.vertx.beans.JcaCryptoOps;
import net.trajano.ms.vertx.beans.JwksRouteHandler;
import net.trajano.ms.vertx.jaxrs.CommonMsJaxRs;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.ExitCodeGenerator;
import org.springframework.boot.SpringApplication;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.AnnotationConfigApplicationContext;
import org.springframework.stereotype.Component;

@Component
public class VertxMicroserviceEngine
implements MicroserviceEngine {
    private static final Logger LOG = LoggerFactory.getLogger(VertxMicroserviceEngine.class);
    @Autowired
    private AnnotationConfigApplicationContext applicationContext;
    private final Deque<AutoCloseable> handlerStack = new LinkedList<AutoCloseable>();
    @Autowired
    private HttpServerOptions httpServerOptions;
    @Autowired
    private JaxRsRouter jaxRsRouter;
    private String theHostname;
    private int thePort = -1;
    private Vertx vertx;
    @Autowired
    private VertxOptions vertxOptions;

    public Object[] bootstrap() {
        System.setProperty("vertx.logger-delegate-factory-class-name", "io.vertx.core.logging.SLF4JLogDelegateFactory");
        File logbackFile = new File("logback.xml");
        if (logbackFile.exists()) {
            System.setProperty("logging.config", logbackFile.getAbsolutePath());
        }
        return new Object[]{VertxConfig.class, VertxMicroserviceEngine.class};
    }

    public String hostname() {
        return this.theHostname;
    }

    public int port() {
        return this.thePort;
    }

    @PostConstruct
    public void start() {
        LOG.debug("Application={}", (Object)Microservice.getApplicationClass());
        this.vertx = Vertx.vertx((VertxOptions)this.vertxOptions);
        if (Microservice.getApplicationClass() == null) {
            LOG.warn("No application class specified, assuming running as a unit test");
            return;
        }
        Router router = Router.router((Vertx)this.vertx);
        this.handlerStack.push((AutoCloseable)SwaggerHandler.registerToRouter((Router)router, (Class)Microservice.getApplicationClass()));
        this.handlerStack.push((AutoCloseable)ManifestHandler.registerToRouter((Router)router));
        Handler notFoundHandler = ctx -> ctx.response().setStatusCode(404).setStatusMessage(Response.Status.NOT_FOUND.getReasonPhrase()).end(Response.Status.NOT_FOUND.getReasonPhrase());
        router.get("/favicon.ico").handler(notFoundHandler);
        this.applicationContext.register(new Class[]{GsonJacksonJsonOps.class, GsonProvider.class, JcaCryptoOps.class, CachedDataProvider.class, JwksRouteHandler.class, CommonMsJaxRs.class});
        SpringJaxRsHandler springJaxRsHandler = new SpringJaxRsHandler((ConfigurableApplicationContext)this.applicationContext, Microservice.getApplicationClass());
        this.jaxRsRouter.register(Microservice.getApplicationClass(), router, (PathsProvider)springJaxRsHandler, (Handler)springJaxRsHandler);
        this.handlerStack.push((AutoCloseable)springJaxRsHandler);
        Handler jwksRouteHandler = (Handler)this.applicationContext.getBean(JwksRouteHandler.class);
        router.route("/.well-known/jwks").order(-1).handler(jwksRouteHandler);
        HttpServer http = this.vertx.createHttpServer(this.httpServerOptions);
        http.requestHandler(arg_0 -> ((Router)router).accept(arg_0)).listen(res -> {
            if (res.failed()) {
                LOG.error("Listening on port {} failed", (Object)this.httpServerOptions.getPort(), (Object)res.cause());
                SpringApplication.exit((ApplicationContext)this.applicationContext, (ExitCodeGenerator[])new ExitCodeGenerator[]{() -> -1});
            } else {
                LOG.info("Listening on port {}", (Object)http.actualPort());
                this.thePort = http.actualPort();
            }
        });
        try {
            this.theHostname = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            throw new ExceptionInInitializerError(e);
        }
    }

    @PreDestroy
    public void stop() throws Exception {
        while (this.handlerStack.peek() != null) {
            this.handlerStack.pop().close();
        }
        this.vertx.close();
    }
}

