/*
 * Decompiled with CFR 0.152.
 */
package net.trajano.ms.vertx.test;

import javax.ws.rs.InternalServerErrorException;
import net.trajano.ms.core.CryptoOps;
import net.trajano.ms.core.ErrorResponse;
import net.trajano.ms.core.JsonOps;
import net.trajano.ms.vertx.beans.CachedDataProvider;
import net.trajano.ms.vertx.beans.GsonJacksonJsonOps;
import net.trajano.ms.vertx.beans.GsonProvider;
import net.trajano.ms.vertx.beans.JcaCryptoOps;
import net.trajano.ms.vertx.beans.TokenGenerator;
import net.trajano.ms.vertx.test.TestConfig;
import org.jose4j.jwk.HttpsJwks;
import org.jose4j.jwt.JwtClaims;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mockito;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.test.context.junit4.SpringRunner;

@RunWith(value=SpringRunner.class)
@SpringBootTest(classes={GsonJacksonJsonOps.class, GsonProvider.class, JcaCryptoOps.class, CachedDataProvider.class, TokenGenerator.class, TestConfig.class})
public class OpsTest {
    @Autowired
    private CachedDataProvider cachedDataProvider;
    @Autowired
    private CryptoOps cryptoOps;
    @Autowired
    private JsonOps jsonOps;

    @Test(expected=InternalServerErrorException.class)
    public void testBadCrypto() throws Exception {
        JwtClaims claims = new JwtClaims();
        claims.setAudience("mememe");
        this.cachedDataProvider.getKeySet();
        HttpsJwks jwks = (HttpsJwks)Mockito.mock(HttpsJwks.class);
        this.cryptoOps.toClaimsSet("XXXXXX", "mememe", jwks);
    }

    @Test
    public void testBinding() {
        String error = "{\"error\":\"testing\", \"error_description\": \"blah\"}";
        ErrorResponse response = (ErrorResponse)this.jsonOps.fromJson("{\"error\":\"testing\", \"error_description\": \"blah\"}", ErrorResponse.class);
        Assert.assertEquals((Object)"testing", (Object)response.getError());
    }

    @Test
    public void testCrypto() throws Exception {
        JwtClaims claims = new JwtClaims();
        claims.setAudience("mememe");
        String jwt = this.cryptoOps.sign(claims);
        this.cachedDataProvider.getKeySet();
        HttpsJwks jwks = (HttpsJwks)Mockito.mock(HttpsJwks.class);
        Mockito.when((Object)jwks.getJsonWebKeys()).thenReturn((Object)this.cachedDataProvider.getKeySet().getJsonWebKeys());
        JwtClaims readClaims = this.cryptoOps.toClaimsSet(jwt, "mememe", jwks);
        Assert.assertEquals((Object)claims.toJson(), (Object)readClaims.toJson());
        readClaims = this.cryptoOps.toClaimsSet(jwt, jwks);
        Assert.assertEquals((Object)claims.toJson(), (Object)readClaims.toJson());
    }

    @Test
    public void testNotNull() throws Exception {
        Assert.assertNotNull((Object)this.cryptoOps);
        Assert.assertNotNull((Object)this.cryptoOps.newToken());
    }
}

