/*
 * Decompiled with CFR 0.152.
 */
package net.trajano.ms.vertx.test;

import java.net.URI;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ResourceInfo;
import javax.ws.rs.core.UriInfo;
import net.trajano.ms.core.CryptoOps;
import net.trajano.ms.sample.Hello;
import net.trajano.ms.vertx.VertxConfig;
import net.trajano.ms.vertx.beans.JwtClaimsProcessor;
import net.trajano.ms.vertx.jaxrs.JwtAssertionInterceptor;
import net.trajano.ms.vertx.jaxrs.MDCInterceptor;
import org.jose4j.jwt.JwtClaims;
import org.jose4j.jwt.MalformedClaimException;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mockito;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.test.context.junit4.SpringRunner;

@RunWith(value=SpringRunner.class)
@SpringBootTest(classes={VertxConfig.class})
public class InterceptorTest {
    @Autowired
    private CryptoOps cryptoOps;
    @Autowired
    private JwtAssertionInterceptor jwtInterceptor;
    @Autowired
    private MDCInterceptor mdcInterceptor;

    @Test
    public void testInterceptor() throws Exception {
        this.jwtInterceptor.setClaimsProcessor((JwtClaimsProcessor)new ValidatingProcessor("typ", "https://example.com/register"));
        JwtClaims jwtClaims = JwtClaims.parse((String)"{\"typ\":\"https://example.com/register\", \"aud\":\"sample\", \"jti\": \"abc\", \"iss\":\"http://accounts.trajano.net\"}");
        String jwt = this.cryptoOps.sign(jwtClaims);
        System.out.println(jwt);
        ResourceInfo resourceInfo = (ResourceInfo)Mockito.mock(ResourceInfo.class);
        Mockito.when((Object)resourceInfo.getResourceMethod()).thenReturn((Object)Hello.class.getMethod("hello2B", new Class[0]));
        Mockito.when((Object)resourceInfo.getResourceClass()).thenReturn(Hello.class);
        this.jwtInterceptor.setResourceInfo(resourceInfo);
        ContainerRequestContext containerRequestContext = (ContainerRequestContext)Mockito.mock(ContainerRequestContext.class);
        UriInfo uriInfo = (UriInfo)Mockito.mock(UriInfo.class);
        Mockito.when((Object)uriInfo.getRequestUri()).thenReturn((Object)URI.create("http://trajano.net/sample"));
        Mockito.when((Object)containerRequestContext.getUriInfo()).thenReturn((Object)uriInfo);
        Mockito.when((Object)containerRequestContext.getHeaderString("X-JWT-Assertion")).thenReturn((Object)jwt);
        Mockito.when((Object)containerRequestContext.getHeaderString("X-JWT-Audience")).thenReturn((Object)"sample");
        this.mdcInterceptor.filter(containerRequestContext);
        this.jwtInterceptor.filter(containerRequestContext);
    }

    private static final class ValidatingProcessor
    implements JwtClaimsProcessor {
        final String claimName;
        final String claimValue;

        ValidatingProcessor(String claimName, String claimValue) {
            this.claimName = claimName;
            this.claimValue = claimValue;
        }

        public Boolean apply(JwtClaims claims) {
            try {
                return this.claimValue.equals(claims.getStringClaimValue(this.claimName));
            }
            catch (MalformedClaimException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

