/*
 * Decompiled with CFR 0.152.
 */
package net.trajano.ms.vertx.test;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.Arrays;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import net.trajano.commons.testing.UtilityClassTestUtil;
import net.trajano.ms.core.ErrorCodes;
import net.trajano.ms.core.ErrorResponses;
import net.trajano.ms.core.Qualifiers;
import net.trajano.ms.vertx.jaxrs.JsonExceptionMapper;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class ExceptionMapperTest {
    private JsonExceptionMapper mapper;

    @Test
    public void coverSetDebugFlags() {
        this.mapper.setDebugFlags();
    }

    @Test
    public void coverUtilityClasses() throws Exception {
        UtilityClassTestUtil.assertUtilityClassWellDefined(ErrorCodes.class);
        UtilityClassTestUtil.assertUtilityClassWellDefined(ErrorResponses.class);
        UtilityClassTestUtil.assertUtilityClassWellDefined(Qualifiers.class);
    }

    @Before
    public void setupMapper() {
        this.mapper = new JsonExceptionMapper();
        this.mapper.setDebugFlags();
        HttpHeaders headers = (HttpHeaders)Mockito.mock(HttpHeaders.class);
        Mockito.when((Object)headers.getAcceptableMediaTypes()).thenReturn(Arrays.asList(MediaType.WILDCARD_TYPE));
        this.mapper.setContextData(headers, (UriInfo)Mockito.mock(UriInfo.class), true);
    }

    @Test
    public void testBadRequest() {
        Response response = this.mapper.toResponse((Throwable)new BadRequestException());
        Assert.assertEquals((long)400L, (long)response.getStatus());
    }

    @Test
    public void testBadRequestWithBody() {
        Response resp = Response.status((int)400).entity((Object)"pooh").build();
        Response response = this.mapper.toResponse((Throwable)new BadRequestException(resp));
        Assert.assertEquals((long)400L, (long)response.getStatus());
    }

    @Test
    public void testChecked() {
        Response response = this.mapper.toResponse((Throwable)new IOException());
        Assert.assertEquals((long)500L, (long)response.getStatus());
    }

    @Test
    public void testCheckedHtml() {
        HttpHeaders headers = (HttpHeaders)Mockito.mock(HttpHeaders.class);
        Mockito.when((Object)headers.getAcceptableMediaTypes()).thenReturn(Arrays.asList(MediaType.TEXT_HTML_TYPE));
        this.mapper.setContextData(headers, (UriInfo)Mockito.mock(UriInfo.class), true);
        Response response = this.mapper.toResponse((Throwable)new IOException("ahem"));
        Assert.assertEquals((long)500L, (long)response.getStatus());
        Assert.assertEquals((Object)MediaType.TEXT_HTML_TYPE, (Object)response.getMediaType());
        Assert.assertEquals((Object)"ahem", (Object)response.getEntity());
    }

    @Test
    public void testCheckedNested() {
        Response response = this.mapper.toResponse((Throwable)new IOException("blah", new GeneralSecurityException()));
        Assert.assertEquals((long)500L, (long)response.getStatus());
    }

    @Test
    public void testCheckedPlainText() {
        HttpHeaders headers = (HttpHeaders)Mockito.mock(HttpHeaders.class);
        Mockito.when((Object)headers.getAcceptableMediaTypes()).thenReturn(Arrays.asList(MediaType.TEXT_PLAIN_TYPE));
        this.mapper.setContextData(headers, (UriInfo)Mockito.mock(UriInfo.class), true);
        Response response = this.mapper.toResponse((Throwable)new IOException("ahem"));
        Assert.assertEquals((long)500L, (long)response.getStatus());
        Assert.assertEquals((Object)MediaType.TEXT_PLAIN_TYPE, (Object)response.getMediaType());
        Assert.assertEquals((Object)"ahem", (Object)response.getEntity());
    }

    @Test
    public void testCheckedUnsupportedType() {
        HttpHeaders headers = (HttpHeaders)Mockito.mock(HttpHeaders.class);
        Mockito.when((Object)headers.getAcceptableMediaTypes()).thenReturn(Arrays.asList(MediaType.APPLICATION_OCTET_STREAM_TYPE));
        this.mapper.setContextData(headers, (UriInfo)Mockito.mock(UriInfo.class), true);
        Response response = this.mapper.toResponse((Throwable)new IOException("ahem"));
        Assert.assertEquals((long)500L, (long)response.getStatus());
        Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)response.getMediaType());
    }

    @Test
    public void testNotFound() {
        Response response = this.mapper.toResponse((Throwable)new NotFoundException());
        Assert.assertEquals((long)404L, (long)response.getStatus());
    }

    @Test
    public void testUnchecked() {
        Response response = this.mapper.toResponse((Throwable)new RuntimeException());
        Assert.assertEquals((long)500L, (long)response.getStatus());
    }
}

