/*
 * Decompiled with CFR 0.152.
 */
package net.trajano.ms.sample;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import javax.annotation.security.PermitAll;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import net.trajano.ms.vertx.beans.CachedDataProvider;
import org.jose4j.jwk.JsonWebKey;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@Api
@Path(value="/jwks")
@PermitAll
public class JwksResource {
    @Autowired
    private CachedDataProvider cachedDataProvider;

    @ApiOperation(value="Get public keys", response=Response.class, notes="Provides the JWKS of public keys used for JWS and JWE for clients.")
    @GET
    @Produces(value={"application/json"})
    public String getPublicKeySet() {
        return this.cachedDataProvider.getKeySet().toJson(JsonWebKey.OutputControlLevel.PUBLIC_ONLY);
    }

    public void setCachedDataProvider(CachedDataProvider cachedDataProvider) {
        this.cachedDataProvider = cachedDataProvider;
    }
}

