/*
 * Decompiled with CFR 0.152.
 */
package net.trajano.ms.authz.internal;

import java.time.Instant;
import java.util.Collection;
import javax.annotation.PostConstruct;
import net.trajano.ms.auth.token.IdTokenResponse;
import net.trajano.ms.auth.token.OAuthTokenResponse;
import net.trajano.ms.authz.internal.TokenCacheEntry;
import net.trajano.ms.core.CryptoOps;
import net.trajano.ms.core.ErrorResponses;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cache.Cache;
import org.springframework.cache.CacheManager;
import org.springframework.stereotype.Component;

@Component
public class TokenCache {
    private static final Logger LOG = LoggerFactory.getLogger(TokenCache.class);
    @Value(value="${token.accessTokenExpiration:300}")
    private int accessTokenExpirationInSeconds;
    private Cache accessTokenToEntry;
    @Autowired
    private CacheManager cm;
    @Autowired
    private CryptoOps cryptoOps;
    private Cache refreshTokenToEntry;

    private void evictEntry(TokenCacheEntry cacheEntry) {
        this.accessTokenToEntry.evict((Object)cacheEntry.getAccessToken());
        this.refreshTokenToEntry.evict((Object)cacheEntry.getRefreshToken());
    }

    public IdTokenResponse get(String accessToken) {
        TokenCacheEntry cacheEntry = this.getCacheEntry(accessToken);
        if (cacheEntry == null) {
            return null;
        }
        return new IdTokenResponse(accessToken, cacheEntry.getJwt(), cacheEntry.getAudiences(), cacheEntry.getExpiresInSeconds());
    }

    public TokenCacheEntry getCacheEntry(String accessToken) {
        TokenCacheEntry cacheEntry = (TokenCacheEntry)this.accessTokenToEntry.get((Object)accessToken, TokenCacheEntry.class);
        if (cacheEntry == null) {
            LOG.debug("No entry for accessToken={}", (Object)accessToken);
            return null;
        }
        if (cacheEntry.isExpired()) {
            this.evictEntry(cacheEntry);
            LOG.debug("Entry was expired for accessToken={}", (Object)accessToken);
            return null;
        }
        return cacheEntry;
    }

    @PostConstruct
    public void init() {
        this.accessTokenToEntry = this.cm.getCache("access_token_to_entry");
        this.refreshTokenToEntry = this.cm.getCache("refresh_token_to_entry");
        LOG.debug("cache manager={} accessTokenToEntry={} refreshTokenToEntry={}", new Object[]{this.cm, this.accessTokenToEntry, this.refreshTokenToEntry});
    }

    public OAuthTokenResponse refresh(String refreshToken, String clientId) {
        TokenCacheEntry cacheEntry = (TokenCacheEntry)this.refreshTokenToEntry.get((Object)refreshToken, TokenCacheEntry.class);
        if (cacheEntry == null) {
            throw ErrorResponses.unauthorized((String)"unauthorized_client", (String)"Token rejected", (String)"Bearer");
        }
        if (cacheEntry.isExpired()) {
            this.evictEntry(cacheEntry);
            throw ErrorResponses.badRequest((String)"invalid_request", (String)"JWT has exceeded life time");
        }
        if (!cacheEntry.getAudiences().contains(clientId)) {
            throw ErrorResponses.badRequest((String)"invalid_request", (String)"Client mismatch");
        }
        return this.updateEntry(cacheEntry);
    }

    public void revokeRefreshToken(String refreshToken, String clientId) {
        TokenCacheEntry cacheEntry = (TokenCacheEntry)this.refreshTokenToEntry.get((Object)refreshToken, TokenCacheEntry.class);
        if (cacheEntry == null) {
            return;
        }
        if (!cacheEntry.getAudiences().contains(clientId)) {
            throw ErrorResponses.badRequest((String)"invalid_request", (String)"Client mismatch");
        }
        this.evictEntry(cacheEntry);
    }

    public OAuthTokenResponse store(String jwt, Collection<String> audiences, Instant expiresOn) {
        String accessToken = this.cryptoOps.newToken();
        String refreshToken = this.cryptoOps.newToken();
        TokenCacheEntry newCacheEntry = new TokenCacheEntry(accessToken, refreshToken, jwt, audiences, expiresOn);
        this.accessTokenToEntry.putIfAbsent((Object)accessToken, (Object)newCacheEntry);
        this.refreshTokenToEntry.putIfAbsent((Object)refreshToken, (Object)newCacheEntry);
        OAuthTokenResponse oauthTokenResponse = new OAuthTokenResponse();
        oauthTokenResponse.setAccessToken(accessToken);
        oauthTokenResponse.setTokenType("Bearer");
        oauthTokenResponse.setExpiresIn(this.accessTokenExpirationInSeconds);
        oauthTokenResponse.setRefreshToken(refreshToken);
        return oauthTokenResponse;
    }

    private OAuthTokenResponse updateEntry(TokenCacheEntry cacheEntry) {
        this.evictEntry(cacheEntry);
        return this.store(cacheEntry.getJwt(), cacheEntry.getAudiences(), cacheEntry.getExpiresOn());
    }
}

