/*
 * Decompiled with CFR 0.152.
 */
package net.trajano.ms.auth.test;

import javax.ws.rs.BadRequestException;
import net.trajano.ms.auth.util.AuthorizationType;
import net.trajano.ms.auth.util.HttpAuthorizationHeaders;
import org.junit.Assert;
import org.junit.Test;

public class HeadersTest {
    @Test
    public void testAuthorization() throws Exception {
        String authorization = "Basic YXNkZjphc2Rm";
        Assert.assertEquals((Object)AuthorizationType.BASIC, (Object)HttpAuthorizationHeaders.getAuthorizationType((String)"Basic YXNkZjphc2Rm"));
        String[] clientCredentials = HttpAuthorizationHeaders.parseBasicAuthorization((String)"Basic YXNkZjphc2Rm");
        Assert.assertNotNull((Object)clientCredentials);
        Assert.assertEquals((Object)"asdf", (Object)clientCredentials[0]);
        Assert.assertEquals((Object)"asdf", (Object)clientCredentials[1]);
    }

    @Test(expected=BadRequestException.class)
    public void testBadAuthorization() throws Exception {
        String authorization = "aBasic YXNkZjphc2Rm";
        HttpAuthorizationHeaders.parseBasicAuthorization((String)"aBasic YXNkZjphc2Rm");
    }

    @Test(expected=BadRequestException.class)
    public void testBadAuthorization2() throws Exception {
        String authorization = "aBasic YXNkZjphc2Rm";
        HttpAuthorizationHeaders.getAuthorizationType((String)"aBasic YXNkZjphc2Rm");
    }

    @Test
    public void testBearerAuthorization() throws Exception {
        String authorization = "Bearer YXNkZjphc2Rm";
        Assert.assertEquals((Object)AuthorizationType.BEARER, (Object)HttpAuthorizationHeaders.getAuthorizationType((String)"Bearer YXNkZjphc2Rm"));
        String clientCredentials = HttpAuthorizationHeaders.parseBeaerAuthorization((String)"Bearer YXNkZjphc2Rm");
        Assert.assertEquals((Object)"YXNkZjphc2Rm", (Object)clientCredentials);
    }
}

