/*
 * Decompiled with CFR 0.152.
 */
package net.trajano.ms.authz.internal;

import java.io.Serializable;
import java.time.Duration;
import java.time.Instant;
import java.util.Collection;
import java.util.Date;

public class TokenCacheEntry
implements Serializable {
    private static final long serialVersionUID = -1643672416756418254L;
    private final String accessToken;
    private final Collection<String> audiences;
    private final Date createdOn;
    private final Date expiresOn;
    private final String jwt;
    private final String refreshToken;

    public TokenCacheEntry(String accessToken, String refreshToken, String jwt, Collection<String> audiences) {
        this(accessToken, refreshToken, jwt, audiences, null);
    }

    public TokenCacheEntry(String accessToken, String refreshToken, String jwt, Collection<String> audiences, Instant expiresOn) {
        this.accessToken = accessToken;
        this.refreshToken = refreshToken;
        this.jwt = jwt;
        this.audiences = audiences;
        this.expiresOn = Date.from(expiresOn);
        this.createdOn = Date.from(Instant.now());
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public Collection<String> getAudiences() {
        return this.audiences;
    }

    public Instant getCreatedOn() {
        return this.createdOn.toInstant();
    }

    public Integer getExpiresInSeconds() {
        if (this.expiresOn == null) {
            return null;
        }
        return (int)Duration.between(Instant.now(), this.expiresOn.toInstant()).getSeconds();
    }

    public Instant getExpiresOn() {
        if (this.expiresOn == null) {
            return null;
        }
        return this.expiresOn.toInstant();
    }

    public String getJwt() {
        return this.jwt;
    }

    public String getRefreshToken() {
        return this.refreshToken;
    }

    public boolean isExpired() {
        if (this.expiresOn == null) {
            return false;
        }
        return Instant.now().isAfter(this.expiresOn.toInstant());
    }
}

