/*
 * Decompiled with CFR 0.152.
 */
package net.trajano.ms.authz.jsonclientvalidator;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.net.URI;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import net.trajano.ms.authz.jsonclientvalidator.ClientInfo;
import net.trajano.ms.authz.jsonclientvalidator.Clients;
import net.trajano.ms.authz.spi.ClientValidator;
import net.trajano.ms.core.JsonOps;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class JsonClientValidator
implements ClientValidator {
    private Clients clients;
    @Value(value="${client_validator.file:clients.json}")
    private File clientsFile;
    @Inject
    private JsonOps jsonOps;

    private ClientInfo getClientInfo(String clientId) {
        return this.clients.getClients().stream().filter(info -> clientId.equals(info.getClientId())).collect(Collectors.collectingAndThen(Collectors.toList(), list -> {
            if (list.isEmpty()) {
                return null;
            }
            if (list.size() > 1) {
                throw new IllegalStateException("more than one match found");
            }
            return (ClientInfo)list.get(0);
        }));
    }

    @Override
    public URI getJwksUri(String clientId) {
        return this.getClientInfo(clientId).getJwksUri();
    }

    @Override
    public URI getRedirectUri(String clientId) {
        return this.getClientInfo(clientId).getRedirectUri();
    }

    @PostConstruct
    public void init() throws IOException {
        this.clients = (Clients)this.jsonOps.fromJson((Reader)new FileReader(this.clientsFile), Clients.class);
    }

    @Override
    public boolean isOriginAllowed(String clientId, URI origin) {
        return this.getClientInfo(clientId).isOriginAllowed(origin);
    }

    @Override
    public boolean isOriginAllowed(URI origin) {
        return this.clients.getClients().stream().anyMatch(info -> info.getOrigin().equals(origin));
    }

    @Override
    public boolean isValid(String grantType, String clientId, String clientSecret) {
        ClientInfo clientInfo = this.getClientInfo(clientId);
        if (grantType == null) {
            return clientInfo != null && clientInfo.matches(clientId, clientSecret);
        }
        return clientInfo != null && clientInfo.matches(grantType, clientId, clientSecret);
    }
}

