/*
 * Decompiled with CFR 0.152.
 */
package net.trajano.ms.auth.util;

import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.trajano.ms.auth.util.AuthorizationType;
import net.trajano.ms.core.ErrorResponses;

public final class HttpAuthorizationHeaders {
    private static final Pattern BASIC_AUTHORIZATION_PATTERN = Pattern.compile("^Basic ((?:[A-Za-z0-9+/]{4})*(?:[A-Za-z0-9+/]{2}==|[A-Za-z0-9+/]{3}=)?)$");
    private static final Pattern BEARER_AUTHORIZATION_PATTERN = Pattern.compile("^Bearer ([-_A-Za-z0-9]+)$");

    public static String buildBasicAuthorization(String username, String password) {
        StringBuilder b = new StringBuilder("Basic ");
        b.append(Base64.getEncoder().encodeToString((username + ":" + password).getBytes(StandardCharsets.UTF_8)));
        return b.toString();
    }

    public static AuthorizationType getAuthorizationType(String authorization) {
        if (authorization == null) {
            throw ErrorResponses.missingAuthorization();
        }
        if (authorization.startsWith("Bearer ")) {
            return AuthorizationType.BEARER;
        }
        if (authorization.startsWith("Basic ")) {
            return AuthorizationType.BASIC;
        }
        throw ErrorResponses.invalidAuthorization();
    }

    public static String[] parseBasicAuthorization(String authorization) {
        if (authorization == null) {
            throw ErrorResponses.missingAuthorization();
        }
        Matcher m = BASIC_AUTHORIZATION_PATTERN.matcher(authorization);
        if (m.matches()) {
            String decoded = new String(Base64.getDecoder().decode(m.group(1)), StandardCharsets.UTF_8);
            int colonPosition = decoded.indexOf(58);
            return new String[]{decoded.substring(0, colonPosition), decoded.substring(colonPosition + 1)};
        }
        throw ErrorResponses.invalidRequest((String)"authorization is not valid");
    }

    public static String parseBeaerAuthorization(String authorization) {
        if (authorization == null) {
            throw ErrorResponses.missingAuthorization();
        }
        Matcher m = BEARER_AUTHORIZATION_PATTERN.matcher(authorization);
        if (m.matches()) {
            return m.group(1);
        }
        throw ErrorResponses.invalidRequest((String)"authorization is not valid");
    }

    private HttpAuthorizationHeaders() {
    }
}

