/*
 * Decompiled with CFR 0.152.
 */
package net.trajano.ms.authz.internal;

import com.hazelcast.config.Config;
import com.hazelcast.config.EntryListenerConfig;
import com.hazelcast.config.MapConfig;
import java.util.EventListener;
import net.trajano.ms.authz.internal.LoggingEntryListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class HazelcastConfiguration {
    private static final Logger LOG = LoggerFactory.getLogger(HazelcastConfiguration.class);
    @Value(value="${token.access_token_expiration:300}")
    private int accessTokenExpirationInSeconds;
    @Autowired
    private LoggingEntryListener entryListener;
    @Value(value="${cache.instance_name:authz}")
    private String instanceName;
    @Value(value="${token.jwk_expiration:1800}")
    private int jwkExpirationInSeconds;
    @Value(value="${token.nonce_expiration:300}")
    private int nonceExpirationInSeconds;
    @Value(value="${token.refresh_token_expiration:3600}")
    private int refreshTokenExpirationInSeconds;

    @Bean
    public Config hazelcastConfig() {
        EntryListenerConfig listener = new EntryListenerConfig();
        if (LOG.isDebugEnabled()) {
            listener.setLocal(true).setImplementation((EventListener)((Object)this.entryListener));
        }
        Config config = new Config().setInstanceName(this.instanceName).setProperty("hazelcast.logging.type", "slf4j").addMapConfig(new MapConfig().setName("access_token_to_entry").setTimeToLiveSeconds(this.accessTokenExpirationInSeconds).setMaxIdleSeconds(this.accessTokenExpirationInSeconds).addEntryListenerConfig(listener)).addMapConfig(new MapConfig().setName("refresh_token_to_entry").setTimeToLiveSeconds(this.refreshTokenExpirationInSeconds).setMaxIdleSeconds(this.refreshTokenExpirationInSeconds).addEntryListenerConfig(listener)).addMapConfig(new MapConfig().setName("nonce").setTimeToLiveSeconds(this.jwkExpirationInSeconds).setMaxIdleSeconds(this.jwkExpirationInSeconds).addEntryListenerConfig(listener));
        LOG.debug("hazelcast config={}", (Object)config);
        return config;
    }
}

