/*
 * Decompiled with CFR 0.152.
 */
package net.trajano.ms.authz;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiParam;
import java.net.URI;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.security.PermitAll;
import javax.ws.rs.Consumes;
import javax.ws.rs.FormParam;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import net.trajano.ms.auth.spi.ClientValidator;
import net.trajano.ms.auth.token.IdTokenResponse;
import net.trajano.ms.auth.token.OAuthTokenResponse;
import net.trajano.ms.auth.util.HttpAuthorizationHeaders;
import net.trajano.ms.authz.internal.TokenCache;
import net.trajano.ms.authz.spi.InternalClaimsBuilder;
import net.trajano.ms.core.CryptoOps;
import net.trajano.ms.core.ErrorResponses;
import org.jose4j.jwk.HttpsJwks;
import org.jose4j.jwt.JwtClaims;
import org.jose4j.jwt.MalformedClaimException;
import org.jose4j.jwt.NumericDate;
import org.jose4j.jwt.consumer.InvalidJwtException;
import org.jose4j.jwt.consumer.JwtConsumer;
import org.jose4j.jwt.consumer.JwtConsumerBuilder;
import org.jose4j.keys.resolvers.HttpsJwksVerificationKeyResolver;
import org.jose4j.keys.resolvers.VerificationKeyResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;
import org.springframework.stereotype.Component;

@Api
@Configuration
@Component
@Path(value="/token")
@PermitAll
public class TokenResource {
    private static final Logger LOG = LoggerFactory.getLogger(TokenResource.class);
    @Autowired
    private ClientValidator clientValidator;
    @Autowired
    private CryptoOps cryptoOps;
    @Autowired
    private InternalClaimsBuilder internalClaimsBuilder;
    @Value(value="${issuer}")
    private URI issuer;
    private final ConcurrentMap<URI, HttpsJwks> jwksMap = new ConcurrentHashMap<URI, HttpsJwks>();
    @Value(value="${token.jwtMaximumLifetime:86400}")
    private int jwtMaximumLifetimeInSeconds;
    @Value(value="${realmName:client_credentials}")
    private String realmName;
    @Autowired
    private TokenCache tokenCache;

    @POST
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Produces(value={"application/json"})
    public OAuthTokenResponse dispatch(@ApiParam(allowableValues="refresh_token, authorization_code") @FormParam(value="grant_type") String grantType, @FormParam(value="code") String code, @FormParam(value="assertion") String assertion, @FormParam(value="aud") String audience, @FormParam(value="refresh_token") String refreshToken, @FormParam(value="jwks_uri") URI jwksUri, @HeaderParam(value="Authorization") String authorization) {
        String[] clientCredentials = HttpAuthorizationHeaders.parseBasicAuthorization(authorization);
        String clientId = clientCredentials[0];
        if (!this.clientValidator.isValid(grantType, clientId, clientCredentials[1])) {
            throw ErrorResponses.unauthorized((String)"unauthorized_client", (String)"Unauthorized client", (String)String.format("Basic realm=\"%s\", encoding=\"UTF-8\"", this.realmName));
        }
        if ("refresh_token".equals(grantType)) {
            return this.handleRefreshGrant(refreshToken, clientId);
        }
        if ("authorization_code".equals(grantType)) {
            return this.handleAuthorizationCodeGrant(code);
        }
        if ("urn:ietf:params:oauth:grant-type:jwt-bearer".equals(grantType)) {
            return this.handleJwtAssertionGrant(assertion, clientId, audience);
        }
        throw ErrorResponses.badRequest((String)"unsupported_grant_type", (String)"Invalid grant type");
    }

    private IdTokenResponse handleAuthorizationCodeGrant(String accessToken) {
        if (accessToken == null) {
            throw ErrorResponses.invalidRequest((String)"Missing access token");
        }
        IdTokenResponse idTokenResponse = this.tokenCache.get(accessToken);
        if (idTokenResponse == null) {
            throw ErrorResponses.unauthorized((String)"unauthorized_client", (String)"Access token was not valid", (String)"Bearer");
        }
        return idTokenResponse;
    }

    private OAuthTokenResponse handleJwtAssertionGrant(String assertion, String clientId, String audience) {
        if (assertion == null) {
            throw ErrorResponses.badRequest((String)"invalid_request", (String)"Missing assertion");
        }
        if (clientId == null) {
            throw ErrorResponses.badRequest((String)"invalid_request", (String)"Missing client_id");
        }
        try {
            URI jwksUri = this.clientValidator.getJwksUri(clientId);
            LOG.debug("jwksUri={}", (Object)jwksUri);
            HttpsJwks httpsJwks = null;
            if (jwksUri != null) {
                httpsJwks = this.jwksMap.computeIfAbsent(jwksUri, uri -> new HttpsJwks(uri.toASCIIString()));
            }
            JwtConsumerBuilder builder = new JwtConsumerBuilder();
            if (httpsJwks == null) {
                builder.setDisableRequireSignature().setSkipSignatureVerification();
            } else {
                builder.setVerificationKeyResolver((VerificationKeyResolver)new HttpsJwksVerificationKeyResolver(httpsJwks));
            }
            if (audience == null) {
                builder.setExpectedAudience(new String[]{clientId});
            } else {
                builder.setExpectedAudience(new String[]{clientId, audience});
            }
            JwtConsumer jwtConsumer = builder.build();
            JwtClaims internalClaims = this.internalClaimsBuilder.buildInternalJWTClaimsSet(jwtConsumer.processToClaims(assertion));
            if (internalClaims.getSubject() == null) {
                LOG.error("Subject is missing from {}", (Object)internalClaims);
                throw ErrorResponses.internalServerError((String)"Subject is missing from the resulting claims set.");
            }
            internalClaims.setGeneratedJwtId();
            internalClaims.setIssuer(this.issuer.toASCIIString());
            if (audience == null) {
                internalClaims.setAudience(clientId);
            } else {
                internalClaims.setAudience(new String[]{clientId, audience});
            }
            internalClaims.setIssuedAtToNow();
            Instant expirationTime = Instant.now().plus((long)this.jwtMaximumLifetimeInSeconds, ChronoUnit.SECONDS);
            internalClaims.setExpirationTime(NumericDate.fromMilliseconds((long)expirationTime.toEpochMilli()));
            return this.tokenCache.store(this.cryptoOps.sign(internalClaims), internalClaims.getAudience(), expirationTime);
        }
        catch (MalformedClaimException | InvalidJwtException e) {
            LOG.error("Unable to parse assertion", e);
            throw ErrorResponses.badRequest((String)"invalid_request", (String)"Unable to parse assertion");
        }
    }

    private OAuthTokenResponse handleRefreshGrant(String refreshToken, String clientId) {
        if (refreshToken == null) {
            throw ErrorResponses.badRequest((String)"invalid_request", (String)"Missing refresh token");
        }
        return this.tokenCache.refresh(refreshToken, clientId);
    }
}

