/*
 * Decompiled with CFR 0.152.
 */
package net.trajano.ms.authz;

import io.swagger.annotations.Api;
import java.net.URI;
import javax.annotation.security.PermitAll;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.core.Response;
import net.trajano.ms.auth.spi.ClientValidator;
import net.trajano.ms.auth.util.AuthorizationType;
import net.trajano.ms.auth.util.HttpAuthorizationHeaders;
import net.trajano.ms.authz.ClientCheckRequest;
import net.trajano.ms.authz.internal.TokenCache;
import net.trajano.ms.authz.internal.TokenCacheEntry;
import net.trajano.ms.core.ErrorResponses;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Api
@Component
@Path(value="/check")
@PermitAll
public class ClientCheckResource {
    @Autowired
    private ClientValidator clientValidator;
    @Autowired
    private TokenCache tokenCache;

    @POST
    @Consumes(value={"application/json"})
    public Response validateClient(ClientCheckRequest req) {
        boolean validClient = false;
        AuthorizationType authorizationType = HttpAuthorizationHeaders.getAuthorizationType(req.getAuthorization());
        if (authorizationType == AuthorizationType.BASIC) {
            validClient = this.clientValidator.isOriginAllowedFromAuthorization(URI.create(req.getOrigin()), req.getAuthorization());
        } else if (authorizationType == AuthorizationType.BEARER) {
            String accessToken = HttpAuthorizationHeaders.parseBeaerAuthorization(req.getAuthorization());
            TokenCacheEntry cacheEntry = this.tokenCache.getCacheEntry(accessToken);
            if (cacheEntry == null) {
                throw ErrorResponses.invalidRequest((String)"access_token is not valid");
            }
            String clientId = cacheEntry.getAudiences().iterator().next();
            validClient = this.clientValidator.isOriginAllowed(clientId, req.getOrigin());
        }
        if (validClient) {
            return Response.noContent().build();
        }
        throw ErrorResponses.invalidRequest((String)"Invalid Origin for Client");
    }
}

