/*
 * Decompiled with CFR 0.152.
 */
package net.trajano.ms.auth.spi;

import java.net.URI;
import net.trajano.ms.auth.util.HttpAuthorizationHeaders;
import net.trajano.ms.core.ErrorResponses;

public interface ClientValidator {
    default public URI getJwksUri(String clientId) {
        return null;
    }

    default public boolean isValid(String grantType, String authorization) {
        String[] authInfo = HttpAuthorizationHeaders.parseBasicAuthorization(authorization);
        return this.isValid(grantType, authInfo[0], authInfo[1]);
    }

    default public URI getRedirectUriFromAuthorization(String authorization) {
        String[] authInfo = HttpAuthorizationHeaders.parseBasicAuthorization(authorization);
        if (!this.isValid(null, authInfo[0], authInfo[1])) {
            throw ErrorResponses.unauthorized((String)"unauthorized_client", (String)"Unauthorized client", (String)"Basic");
        }
        return this.getRedirectUri(authInfo[0]);
    }

    default public boolean isOriginAllowed(String clientId, String origin) {
        if (origin == null) {
            return false;
        }
        return this.isOriginAllowed(clientId, URI.create(origin));
    }

    public boolean isOriginAllowed(String var1, URI var2);

    public URI getRedirectUri(String var1);

    public boolean isValid(String var1, String var2, String var3);

    default public boolean isOriginAllowedFromAuthorization(URI originUri, String authorization) {
        String[] authInfo = HttpAuthorizationHeaders.parseBasicAuthorization(authorization);
        if (!this.isValid(null, authInfo[0], authInfo[1])) {
            throw ErrorResponses.unauthorized((String)"unauthorized_client", (String)"Unauthorized client", (String)"Basic");
        }
        return this.isOriginAllowed(authInfo[0], originUri);
    }
}

