/*
 * Decompiled with CFR 0.152.
 */
package net.trajano.ms.auth.jsonclientvalidator;

import java.net.URI;
import java.util.HashSet;
import java.util.Set;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement
public class ClientInfo {
    @XmlElement(name="client_id", required=true)
    private String clientId;
    @XmlElement(name="client_secret", required=true)
    private String clientSecret;
    @XmlElement(name="grant_types", required=true, type=String.class)
    private Set<String> grantTypes = new HashSet<String>();
    @XmlElement(name="jwks_uri", required=false)
    private URI jwksUri;
    @XmlElement(name="origin", required=false)
    private URI origin;
    @XmlElement(name="redirect_uri", required=false)
    private URI redirectUri;

    public String getClientId() {
        return this.clientId;
    }

    public String getClientSecret() {
        return this.clientSecret;
    }

    public Set<String> getGrantTypes() {
        return this.grantTypes;
    }

    public URI getJwksUri() {
        return this.jwksUri;
    }

    public URI getOrigin() {
        return this.origin;
    }

    public URI getRedirectUri() {
        return this.redirectUri;
    }

    public boolean isOriginAllowed(URI origin) {
        return this.origin.equals(origin);
    }

    public boolean matches(String clientId, String clientSecret) {
        return this.clientId.equals(clientId) && this.clientSecret.equals(clientSecret);
    }

    public boolean matches(String grantType, String clientId, String clientSecret) {
        return this.grantTypes.contains(grantType) && this.clientId.equals(clientId) && this.clientSecret.equals(clientSecret);
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public void setClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
    }

    public void setGrantTypes(Set<String> grantTypes) {
        this.grantTypes = grantTypes;
    }

    public void setJwksUri(URI jwksUri) {
        this.jwksUri = jwksUri;
    }

    public void setOrigin(URI origin) {
        this.origin = origin;
    }

    public void setRedirectUri(URI redirectUri) {
        this.redirectUri = redirectUri;
    }
}

