/*
 * Decompiled with CFR 0.152.
 */
package net.trajano.ms.authz;

import com.google.gson.JsonObject;
import io.swagger.annotations.Api;
import java.text.ParseException;
import javax.annotation.security.PermitAll;
import javax.ws.rs.Consumes;
import javax.ws.rs.FormParam;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import net.trajano.ms.auth.spi.ClientValidator;
import net.trajano.ms.auth.token.OAuthTokenResponse;
import net.trajano.ms.auth.util.HttpAuthorizationHeaders;
import net.trajano.ms.authz.internal.TokenCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;
import org.springframework.stereotype.Component;

@Api
@Configuration
@Component
@Path(value="/revoke")
@PermitAll
public class RevocationResource {
    private static final Logger LOG = LoggerFactory.getLogger(RevocationResource.class);
    @Autowired
    private ClientValidator clientValidator;
    @Value(value="${token.jwtMaximumLifetime:86400}")
    private int jwtMaximumLifetimeInSeconds;
    @Value(value="${realmName:client_credentials}")
    private String realmName;
    @Autowired
    private TokenCache tokenCache;

    @POST
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Produces(value={"application/json"})
    public JsonObject revoke(@FormParam(value="token") String token, @FormParam(value="token_type_hint") String tokenTypeHint, @HeaderParam(value="Authorization") String authorization) {
        String clientId;
        try {
            String[] clientCredentials = HttpAuthorizationHeaders.parseBasicAuthorization(authorization);
            clientId = clientCredentials[0];
            if (!this.clientValidator.isValid("revocation", clientId, clientCredentials[1])) {
                throw OAuthTokenResponse.unauthorized("unauthorized_client", "Unauthorized client", String.format("Basic realm=\"%s\", encoding=\"UTF-8\"", this.realmName));
            }
        }
        catch (ParseException e) {
            throw OAuthTokenResponse.unauthorized("unauthorized_client", "Invalid or missing authorization", String.format("Basic realm=\"%s\", encoding=\"UTF-8\"", this.realmName));
        }
        if (token == null) {
            throw OAuthTokenResponse.badRequest("invalid_request", "Missing token");
        }
        if (tokenTypeHint != null && !"refresh_token".equals(tokenTypeHint)) {
            throw OAuthTokenResponse.badRequest("unsupported_token_type", "Token type is not supported");
        }
        this.tokenCache.revokeRefreshToken(token, clientId);
        LOG.debug("revoked token={}", (Object)token);
        JsonObject okReturn = new JsonObject();
        okReturn.addProperty("ok", (Number)1);
        return okReturn;
    }
}

