/*
 * Decompiled with CFR 0.152.
 */
package net.trajano.ms.auth.util;

import java.nio.charset.StandardCharsets;
import java.text.ParseException;
import java.util.Base64;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class HttpAuthorizationHeaders {
    private static final Pattern BASIC_AUTHORIZATION_PATTERN = Pattern.compile("^Basic ((?:[A-Za-z0-9+/]{4})*(?:[A-Za-z0-9+/]{2}==|[A-Za-z0-9+/]{3}=)?)$");

    public static String buildBasicAuthorization(String username, String password) {
        StringBuilder b = new StringBuilder("Basic ");
        b.append(Base64.getEncoder().encodeToString((username + ":" + password).getBytes(StandardCharsets.UTF_8)));
        return b.toString();
    }

    public static String[] parseBasicAuthorization(String authorization) throws ParseException {
        if (authorization == null) {
            throw new ParseException("authorization is blank", 0);
        }
        Matcher m = BASIC_AUTHORIZATION_PATTERN.matcher(authorization);
        if (m.matches()) {
            String decoded = new String(Base64.getDecoder().decode(m.group(1)), StandardCharsets.UTF_8);
            int colonPosition = decoded.indexOf(58);
            return new String[]{decoded.substring(0, colonPosition), decoded.substring(colonPosition + 1)};
        }
        throw new ParseException("authorization is blank", 0);
    }

    private HttpAuthorizationHeaders() {
    }
}

