/*
 * Decompiled with CFR 0.152.
 */
package net.trajano.ms.auth.token;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.io.Serializable;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.InternalServerErrorException;
import javax.ws.rs.NotAuthorizedException;
import javax.ws.rs.core.Response;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.NONE)
@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class OAuthTokenResponse
implements Serializable {
    private static final long serialVersionUID = -6845634801856757737L;
    @XmlElement(name="access_token")
    private String accessToken;
    @XmlElement(name="error")
    private String error;
    @XmlElement(name="error_description")
    private String errorDescription;
    @XmlElement(name="expires_in")
    private Integer expiresIn;
    @XmlElement(name="refresh_token")
    private String refreshToken;
    @XmlElement(name="token_type", required=true)
    private String tokenType;

    public static BadRequestException badRequest(String error, String errorDescription) {
        OAuthTokenResponse r = new OAuthTokenResponse();
        r.setError(error);
        r.setErrorDescription(errorDescription);
        return new BadRequestException(Response.ok((Object)r, (String)"application/json").status(Response.Status.BAD_REQUEST).build());
    }

    public static InternalServerErrorException internalServerError(String message) {
        OAuthTokenResponse r = new OAuthTokenResponse();
        r.setError("server_error");
        r.setErrorDescription(Response.Status.INTERNAL_SERVER_ERROR.getReasonPhrase());
        return new InternalServerErrorException(message, Response.ok((Object)r, (String)"application/json").status(Response.Status.INTERNAL_SERVER_ERROR).build());
    }

    public static InternalServerErrorException internalServerError(Throwable e) {
        OAuthTokenResponse r = new OAuthTokenResponse();
        r.setError("server_error");
        r.setErrorDescription(Response.Status.INTERNAL_SERVER_ERROR.getReasonPhrase());
        return new InternalServerErrorException(Response.ok((Object)r, (String)"application/json").status(Response.Status.INTERNAL_SERVER_ERROR).build(), e);
    }

    public static NotAuthorizedException unauthorized(String error, String errorDescription, String challenge) {
        OAuthTokenResponse r = new OAuthTokenResponse();
        r.setError(error);
        r.setErrorDescription(errorDescription);
        return new NotAuthorizedException(Response.ok((Object)r, (String)"application/json").header("WWW-Authenticate", (Object)challenge).status(Response.Status.UNAUTHORIZED).build());
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public String getError() {
        return this.error;
    }

    public String getErrorDescription() {
        return this.errorDescription;
    }

    public int getExpiresIn() {
        return this.expiresIn;
    }

    public String getRefreshToken() {
        return this.refreshToken;
    }

    public String getTokenType() {
        return this.tokenType;
    }

    public boolean isError() {
        return this.error != null;
    }

    public boolean isExpiring() {
        return this.expiresIn != null;
    }

    public void setAccessToken(String accessToken) {
        this.accessToken = accessToken;
    }

    public void setError(String error) {
        this.error = error;
    }

    public void setErrorDescription(String errorDescription) {
        this.errorDescription = errorDescription;
    }

    public void setExpiresIn(int expiresIn) {
        this.expiresIn = expiresIn;
    }

    public void setRefreshToken(String refreshToken) {
        this.refreshToken = refreshToken;
    }

    public void setTokenType(String tokenType) {
        this.tokenType = tokenType;
    }
}

