/*
 * Decompiled with CFR 0.152.
 */
package net.top_t;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import javax.imageio.ImageIO;
import javax.swing.JLabel;
import org.apache.batik.dom.GenericDOMImplementation;
import org.apache.batik.svggen.SVGGeneratorContext;
import org.apache.batik.svggen.SVGGraphics2D;
import org.apache.batik.transcoder.TranscoderException;
import org.apache.batik.transcoder.TranscoderInput;
import org.apache.batik.transcoder.TranscoderOutput;
import org.apache.fop.render.ps.EPSTranscoder;
import org.apache.fop.render.ps.PSTranscoder;
import org.apache.fop.svg.PDFTranscoder;
import org.scilab.forge.jlatexmath.AlphabetRegistration;
import org.scilab.forge.jlatexmath.DefaultTeXFont;
import org.scilab.forge.jlatexmath.TeXFormula;
import org.scilab.forge.jlatexmath.TeXIcon;
import org.scilab.forge.jlatexmath.cyrillic.CyrillicRegistration;
import org.scilab.forge.jlatexmath.greek.GreekRegistration;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;

public class LaTexConvert {
    private static final int PDF = 0;
    private static final int PS = 1;
    private static final int EPS = 2;

    public static String latexToSvgCode(String latex, boolean fontAsShapes, boolean bkgTransparent) throws IOException {
        DOMImplementation domImpl = GenericDOMImplementation.getDOMImplementation();
        String svgNS = "http://www.w3.org/2000/svg";
        Document document = domImpl.createDocument(svgNS, "svg", null);
        SVGGeneratorContext ctx = SVGGeneratorContext.createDefault((Document)document);
        SVGGraphics2D g2 = new SVGGraphics2D(ctx, fontAsShapes);
        DefaultTeXFont.registerAlphabet((AlphabetRegistration)new CyrillicRegistration());
        DefaultTeXFont.registerAlphabet((AlphabetRegistration)new GreekRegistration());
        TeXFormula formula = new TeXFormula(latex);
        TeXIcon icon = formula.createTeXIcon(0, 20.0f);
        icon.setInsets(new Insets(5, 5, 5, 5));
        int width = icon.getIconWidth();
        int height = icon.getIconHeight();
        g2.setSVGCanvasSize(new Dimension(width, height));
        Color backgroundColor = new Color(255, 255, 255);
        if (bkgTransparent) {
            backgroundColor = new Color(255, 255, 255, 0);
        }
        g2.setColor(backgroundColor);
        g2.fillRect(0, 0, icon.getIconWidth(), icon.getIconHeight());
        JLabel jl = new JLabel();
        jl.setForeground(new Color(0, 0, 0));
        icon.paintIcon((Component)jl, (Graphics)g2, 0, 0);
        boolean useCSS = true;
        StringWriter out = new StringWriter();
        g2.stream((Writer)out, useCSS);
        String svgStr = out.getBuffer().toString();
        out.flush();
        out.close();
        return svgStr;
    }

    public static void toSvgFile(String latexCode, boolean fontAsShapes, boolean bkgTransparent, File svgFile) {
        try {
            String svgCode = LaTexConvert.latexToSvgCode(latexCode, fontAsShapes, bkgTransparent);
            if (null != svgFile) {
                FileOutputStream outputStream = new FileOutputStream(svgFile);
                ((OutputStream)outputStream).write(svgCode.getBytes());
                outputStream.flush();
                ((OutputStream)outputStream).close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void toPngFile(String latexString, File pngFile, boolean isTransparent) throws IOException {
        TeXFormula formula = new TeXFormula(latexString);
        TeXIcon icon = new TeXFormula.TeXIconBuilder(formula).setStyle(0).setSize(20.0f).build();
        icon.setInsets(new Insets(5, 5, 5, 5));
        BufferedImage image = new BufferedImage(icon.getIconWidth(), icon.getIconHeight(), 2);
        Graphics2D g2 = image.createGraphics();
        if (isTransparent) {
            g2.setColor(new Color(255, 255, 255, 0));
        } else {
            g2.setColor(Color.white);
        }
        g2.fillRect(0, 0, icon.getIconWidth(), icon.getIconHeight());
        JLabel jl = new JLabel();
        jl.setForeground(new Color(0, 0, 0));
        icon.paintIcon((Component)jl, (Graphics)g2, 0, 0);
        ImageIO.write((RenderedImage)image, "png", pngFile.getAbsoluteFile());
    }

    public static void toPdf(String latexCode, boolean fontAsShapes, boolean bkgTransparent, File pdfFile) throws TranscoderException, IOException {
        LaTexConvert.svgTo(latexCode, fontAsShapes, bkgTransparent, 0, pdfFile);
    }

    public static void toPs(String latexCode, boolean fontAsShapes, boolean bkgTransparent, File psFile) throws IOException, TranscoderException {
        LaTexConvert.svgTo(latexCode, fontAsShapes, bkgTransparent, 1, psFile);
    }

    public static void toEps(String latexCode, boolean fontAsShapes, boolean bkgTransparent, File epsFile) throws IOException, TranscoderException {
        LaTexConvert.svgTo(latexCode, fontAsShapes, bkgTransparent, 2, epsFile);
    }

    private static void svgTo(String latexCode, boolean fontAsShapes, boolean bkgTransparent, int type, File output) throws IOException, TranscoderException {
        PDFTranscoder trans;
        switch (type) {
            case 0: {
                trans = new PDFTranscoder();
                break;
            }
            case 1: {
                trans = new PSTranscoder();
                break;
            }
            case 2: {
                trans = new EPSTranscoder();
                break;
            }
            default: {
                trans = null;
            }
        }
        String svgCode = LaTexConvert.latexToSvgCode(latexCode, fontAsShapes, bkgTransparent);
        StringReader reader = new StringReader(svgCode);
        TranscoderInput transcoderInput = new TranscoderInput((Reader)reader);
        FileOutputStream outputStream = new FileOutputStream(output);
        TranscoderOutput transcoderOutput = new TranscoderOutput((OutputStream)outputStream);
        assert (trans != null);
        trans.transcode(transcoderInput, transcoderOutput);
        outputStream.flush();
        ((OutputStream)outputStream).close();
    }

    public static void main(String[] args) {
        String latex = "\\begin{array}{l}";
        latex = latex + "\\forall\\varepsilon\\in\\mathbb{R}_+^*\\ \\exists\\eta>0\\ |x-x_0|\\leq\\eta\\Longrightarrow|f(x)-f(x_0)|\\leq\\varepsilon\\\\";
        latex = latex + "\\det\\begin{bmatrix}a_{11}&a_{12}&\\cdots&a_{1n}\\\\a_{21}&\\ddots&&\\vdots\\\\\\vdots&&\\ddots&\\vdots\\\\a_{n1}&\\cdots&\\cdots&a_{nn}\\end{bmatrix}\\overset{\\mathrm{def}}{=}\\sum_{\\sigma\\in\\mathfrak{S}_n}\\varepsilon(\\sigma)\\prod_{k=1}^n a_{k\\sigma(k)}\\\\";
        latex = latex + "\\sideset{_\\alpha^\\beta}{_\\gamma^\\delta}{\\begin{pmatrix}a&b\\\\c&d\\end{pmatrix}}\\\\";
        latex = latex + "\\int_0^\\infty{x^{2n} e^{-a x^2}\\,dx} = \\frac{2n-1}{2a} \\int_0^\\infty{x^{2(n-1)} e^{-a x^2}\\,dx} = \\frac{(2n-1)!!}{2^{n+1}} \\sqrt{\\frac{\\pi}{a^{2n+1}}}\\\\";
        latex = latex + "\\int_a^b{f(x)\\,dx} = (b - a) \\sum\\limits_{n = 1}^\\infty  {\\sum\\limits_{m = 1}^{2^n  - 1} {\\left( { - 1} \\right)^{m + 1} } } 2^{ - n} f(a + m\\left( {b - a} \\right)2^{-n} )\\\\";
        latex = latex + "\\int_{-\\pi}^{\\pi} \\sin(\\alpha x) \\sin^n(\\beta x) dx = \\textstyle{\\left \\{ \\begin{array}{cc} (-1)^{(n+1)/2} (-1)^m \\frac{2 \\pi}{2^n} \\binom{n}{m} & n \\mbox{ odd},\\ \\alpha = \\beta (2m-n) \\\\ 0 & \\mbox{otherwise} \\\\ \\end{array} \\right .}\\\\";
        latex = latex + "L = \\int_a^b \\sqrt{ \\left|\\sum_{i,j=1}^ng_{ij}(\\gamma(t))\\left(\\frac{d}{dt}x^i\\circ\\gamma(t)\\right)\\left(\\frac{d}{dt}x^j\\circ\\gamma(t)\\right)\\right|}\\,dt\\\\";
        latex = latex + "\\begin{array}{rl} s &= \\int_a^b\\left\\|\\frac{d}{dt}\\vec{r}\\,(u(t),v(t))\\right\\|\\,dt \\\\ &= \\int_a^b \\sqrt{u'(t)^2\\,\\vec{r}_u\\cdot\\vec{r}_u + 2u'(t)v'(t)\\, \\vec{r}_u\\cdot\\vec{r}_v+ v'(t)^2\\,\\vec{r}_v\\cdot\\vec{r}_v}\\,\\,\\, dt. \\end{array}\\\\";
        latex = latex + "\\end{array}";
        File imgFile = new File("/tmp/example1.png");
        File svgFile = new File("/tmp/example2.svg");
        try {
            LaTexConvert.toPngFile(latex, imgFile, true);
            LaTexConvert.toSvgFile(latex, true, true, svgFile);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        System.out.println("Hello World!");
    }
}

