/*
 * Decompiled with CFR 0.152.
 */
package net.tomred.liquibase.validator.valiables;

import java.io.IOException;
import java.io.StringReader;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.XMLEvent;
import net.tomred.liquibase.validator.ValidationResponse;
import net.tomred.liquibase.validator.stax.handler.TagHandler;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class ValidChecksumAnyWhenUsingVariables
implements TagHandler {
    private static String TAG_CHANGESET = "changeSet";
    private static String TAG_COLUMN = "validCheckSum";
    private static String VALUE_AUDITSCHEMANAME = "${audit.schema.name}";

    @Override
    public ValidationResponse handle(XMLEvent event, XMLEventReader inputEventReader) throws XMLStreamException {
        String elementText;
        String startElementName;
        if (event.isStartElement() && (startElementName = event.asStartElement().getName().getLocalPart()).equals(TAG_CHANGESET) && (elementText = inputEventReader.getElementText()).contains(VALUE_AUDITSCHEMANAME)) {
            NodeList tags;
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            Document doc = null;
            try {
                DocumentBuilder builder = factory.newDocumentBuilder();
                InputSource is = new InputSource(new StringReader(elementText));
                doc = builder.parse(is);
            }
            catch (SAXException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (ParserConfigurationException e) {
                e.printStackTrace();
            }
            NodeList nodeList = tags = doc != null ? doc.getElementsByTagName(TAG_CHANGESET) : null;
            if (tags != null && tags.getLength() == 1 && !tags.item(0).getTextContent().equals("true")) {
                return new ValidationResponse(ValidationResponse.Level.ERROR, "<" + TAG_CHANGESET + "> with " + VALUE_AUDITSCHEMANAME + " cannot be used without <" + TAG_COLUMN + "> true </" + TAG_COLUMN + "> ");
            }
        }
        return null;
    }
}

