/*
 * Decompiled with CFR 0.152.
 */
package net.tomred.liquibase.validator;

import com.google.inject.AbstractModule;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.ProvisionException;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.tomred.liquibase.validator.LogFactory;
import net.tomred.liquibase.validator.MavenOutput;
import net.tomred.liquibase.validator.ValidationResponse;
import net.tomred.liquibase.validator.ValidatorConfiguration;
import net.tomred.liquibase.validator.add.column.module.AddColumnToAuditSchemaWithRemarksModule;
import net.tomred.liquibase.validator.exists.column.module.ColumnExistsModule;
import net.tomred.liquibase.validator.exists.table.module.TableExistsModule;
import net.tomred.liquibase.validator.global.properties.module.PreventGlobalPropertiesModule;
import net.tomred.liquibase.validator.module.ValidatorModule;
import net.tomred.liquibase.validator.stax.LiquibaseHandler;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="validate", defaultPhase=LifecyclePhase.TEST, threadSafe=true)
public class ValidateMojo
extends AbstractMojo {
    private final Log logger;
    @Parameter(required=false)
    private String dir;
    @Parameter
    private List<String> ignore;
    @Parameter
    private Map<String, Boolean> validators;

    public ValidateMojo() {
        LogFactory.setLogger(this.getLog());
        this.logger = LogFactory.getInstance();
    }

    public void execute() throws MojoExecutionException {
        long start = System.currentTimeMillis();
        if (this.validators == null) {
            this.validators = new HashMap<String, Boolean>();
        }
        Injector injector = this.createInjector();
        try {
            Map<File, List<ValidationResponse>> responses = ((LiquibaseHandler)injector.getInstance(LiquibaseHandler.class)).validate();
            long end = System.currentTimeMillis();
            int errorCount = MavenOutput.printValidationErrors(responses);
            ValidatorConfiguration config = (ValidatorConfiguration)injector.getInstance(ValidatorConfiguration.class);
            MavenOutput.printStatistics(config.getFilesToProcess().size(), responses.size(), errorCount, end - start);
            if (responses.size() > 0) {
                throw new MojoExecutionException("Liquibase Validation Failed.");
            }
        }
        catch (ProvisionException pe) {
            throw new MojoExecutionException("At least one validator must be enabled");
        }
    }

    private Injector createInjector() {
        ArrayList<AbstractModule> modules = new ArrayList<AbstractModule>();
        modules.add(new ValidatorModule(this.getDirectory(), this.ignore));
        if (!this.validators.containsKey("column-exists") || this.validators.get("column-exists").booleanValue()) {
            modules.add(new ColumnExistsModule());
        }
        if (!this.validators.containsKey("table-exists") || this.validators.get("table-exists").booleanValue()) {
            modules.add(new TableExistsModule());
        }
        if (!this.validators.containsKey("add-column-to-audit-schema-with-remarks") || this.validators.get("add-column-to-audit-schema-with-remarks").booleanValue()) {
            modules.add(new AddColumnToAuditSchemaWithRemarksModule());
        }
        if (!this.validators.containsKey("prevent-global-properties") || this.validators.get("prevent-global-properties").booleanValue()) {
            modules.add(new PreventGlobalPropertiesModule());
        }
        if (modules.size() == 1) {
            throw new IllegalStateException("Atleast one Validator must be enabled");
        }
        return Guice.createInjector(modules);
    }

    private File getDirectory() {
        if (this.dir == null) {
            this.dir = ".";
        }
        File directory = new File(this.dir);
        this.logger.info((CharSequence)"-------------------------------------------------------------------------------");
        this.logger.info((CharSequence)("Validating " + directory.getAbsolutePath()));
        this.logger.info((CharSequence)"-------------------------------------------------------------------------------");
        return directory;
    }
}

