/*
 * Decompiled with CFR 0.152.
 */
package net.tomred.liquibase.validator;

import java.io.File;
import java.util.List;
import java.util.Map;
import net.tomred.liquibase.validator.LogFactory;
import net.tomred.liquibase.validator.ValidationResponse;
import org.apache.maven.plugin.logging.Log;

public class MavenOutput {
    private static final Log log = LogFactory.getInstance();

    public static int printValidationErrors(Map<File, List<ValidationResponse>> responses) {
        int validationErrors = 0;
        for (File file : responses.keySet()) {
            if (responses.get(file) == null || responses.get(file).size() <= 0) continue;
            log.error((CharSequence)file.getPath());
            for (ValidationResponse response : responses.get(file)) {
                log.error((CharSequence)(" --- " + response.toString()));
                ++validationErrors;
            }
            log.error((CharSequence)"");
        }
        return validationErrors;
    }

    public static void printStatistics(long filecount, long errorfilecount, long errorcount, long duration) {
        log.info((CharSequence)"-------------------------------------------------------------------------------");
        log.info((CharSequence)"Liquibase Validator ");
        log.info((CharSequence)("\t\tProcessed\t: " + filecount + " files "));
        log.info((CharSequence)("\t\tFound\t\t: " + errorcount + " errors in " + errorfilecount + " files"));
        log.info((CharSequence)("\t\tTotal time\t: " + duration + "ms"));
        log.info((CharSequence)"-------------------------------------------------------------------------------");
    }
}

