package net.tomred.liquibase.validator.valiables;

import java.io.IOException;
import java.io.StringReader;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.XMLEvent;

import net.tomred.liquibase.validator.ValidationResponse;
import net.tomred.liquibase.validator.ValidationResponse.Level;
import net.tomred.liquibase.validator.stax.handler.TagHandler;

import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class ValidChecksumAnyWhenUsingVariables implements TagHandler {

	private static String TAG_CHANGESET = "changeSet";
	private static String TAG_COLUMN = "validCheckSum";
	// TODO reduce this to ${
	private static String VALUE_AUDITSCHEMANAME = "${audit.schema.name}";

	@Override
	public ValidationResponse handle(XMLEvent event, XMLEventReader inputEventReader) throws XMLStreamException {
		if (event.isStartElement()) {
			String startElementName = event.asStartElement().getName().getLocalPart();
			if (startElementName.equals(TAG_CHANGESET)) {
				String elementText = inputEventReader.getElementText();
				if (elementText.contains(VALUE_AUDITSCHEMANAME)) {
					DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
					Document doc = null;
					try {
						DocumentBuilder builder = factory.newDocumentBuilder();
						InputSource is = new InputSource(new StringReader(elementText));
						doc = builder.parse(is);
					} catch (SAXException e) {
						// TODO Auto-generated catch block
						e.printStackTrace();
					} catch (IOException e) {
						// TODO Auto-generated catch block
						e.printStackTrace();
					} catch (ParserConfigurationException e) {
						// TODO Auto-generated catch block
						e.printStackTrace();
					}
					NodeList tags = doc != null ? doc.getElementsByTagName(TAG_CHANGESET) : null;
					if (tags != null && tags.getLength() == 1 && !tags.item(0).getTextContent().equals("true")) {
						return new ValidationResponse(Level.ERROR, "<" + TAG_CHANGESET + "> with " + VALUE_AUDITSCHEMANAME + " cannot be used without <" + TAG_COLUMN + "> true </" + TAG_COLUMN + "> ");
					}
				}
			}
		}
		return null;
	}

}
