package net.tomred.liquibase.validator.module;

import java.io.File;
import java.util.List;

import net.tomred.liquibase.validator.ValidatorConfiguration;

import com.google.inject.AbstractModule;

public class ValidatorModule extends AbstractModule {

	private File dir;
	private List<String> ignore;

	public ValidatorModule(File dir, List<String> ignore) {
		this.dir = dir;
		this.ignore = ignore;
	}

	@Override
	protected void configure() {
		bind(ValidatorConfiguration.class).toInstance(new ValidatorConfiguration(dir, ignore));
	}

}
