package net.tomred.liquibase.validator.global.properties;

import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;

import net.tomred.liquibase.validator.ValidationResponse;
import net.tomred.liquibase.validator.ValidationResponse.Level;
import net.tomred.liquibase.validator.stax.handler.TagHandler;

public class PreventGlobalProperties implements TagHandler {

	private static final String PROPERTY = "property";
	private static final String ATTR_GLOBAL = "global";
	private static final String VALUE_TRUE = "true";

	@Override
	public ValidationResponse handle(XMLEvent event, XMLEventReader inputEventReader) {
		if (event.isStartElement()) {
			StartElement startElement = event.asStartElement();
			String startElementName = startElement.getName().getLocalPart();
			if (startElementName.equals(PROPERTY)) {
				Attribute schemaAttr = startElement.getAttributeByName(new QName(ATTR_GLOBAL));
				if (schemaAttr == null || schemaAttr.getValue().trim().equals(VALUE_TRUE)) {
					return new ValidationResponse(Level.ERROR, "<property /> tag is not permitted without global=\"false\".");
				}
			}
		}
		return null;
	}
}
