package net.tomred.liquibase.validator;

/**
 * Contains the response from Validation
 * 
 * @author Dermot
 */
public class ValidationResponse {

	public enum Level {
		NONE, DEBUG, INFO, WARN, ERROR
	}

	private final Level level;
	private final String message;

	public ValidationResponse(Level level, String message) {
		this.level = level;
		this.message = message;
	}

	public Level getLevel() {
		return level;
	}

	public String getMessage() {
		return message;
	}

	@Override
	public String toString() {
		return level + " - " + message;
	}
}
