package net.tomred.liquibase.validator;

import java.io.File;
import java.util.List;
import java.util.Map;

import org.apache.maven.plugin.logging.Log;

public class MavenOutput {

	private static final Log log = LogFactory.getInstance();

	public static int printValidationErrors(Map<File, List<ValidationResponse>> responses) {
		int validationErrors = 0;
		for (File file : responses.keySet()) {
			if (responses.get(file) != null && responses.get(file).size() > 0) {
				log.error(file.getPath());
				for (ValidationResponse response : responses.get(file)) {
					log.error(" --- " + response.toString());
					validationErrors++;
				}
				log.error("");
			}
		}
		return validationErrors;
	}

	public static void printStatistics(long filecount, long errorfilecount, long errorcount, long duration) {

		log.info("-------------------------------------------------------------------------------");
		log.info("Liquibase Validator ");
		log.info("		Processed	: " + filecount + " files ");
		log.info("		Found		: " + errorcount + " errors in " + errorfilecount + " files");
		log.info("		Total time	: " + duration + "ms");
		log.info("-------------------------------------------------------------------------------");
	}

}
