/*
 * Decompiled with CFR 0.152.
 */
package net.tomred.liquibase.validator.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import net.tomred.liquibase.validator.LogFactory;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.maven.plugin.logging.Log;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class XmlFilenameFilter
implements IOFileFilter {
    private final Log log = LogFactory.getInstance();
    private List<String> ignores = new ArrayList<String>();

    public XmlFilenameFilter(List<String> ignores) {
        if (ignores != null) {
            this.ignores.addAll(ignores);
        }
    }

    public boolean accept(File file) {
        try {
            return this.isNotOnIngoreList(file) && this.isTypeXML(file) && file.exists() && this.isNotEmpty(file) && this.isAccessible(file) && this.containsLiquibaseNamespace(file);
        }
        catch (IOException e) {
            return false;
        }
    }

    private boolean isNotEmpty(File file) {
        return file.length() != 0L;
    }

    private boolean isAccessible(File file) {
        return file.canRead();
    }

    private boolean isTypeXML(File file) {
        return file.getName().endsWith(".xml");
    }

    private boolean isNotOnIngoreList(File file) throws IOException {
        for (String ignore : this.ignores) {
            if (!file.getCanonicalPath().trim().contains(ignore.trim())) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean containsLiquibaseNamespace(File file) {
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(file);
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(true);
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document document = db.parse(fis);
            Element node = document.getDocumentElement();
            String namespaceURI = node.getNamespaceURI();
            boolean bl = namespaceURI != null && namespaceURI.contains("http://www.liquibase.org");
            return bl;
        }
        catch (FileNotFoundException e) {
            this.logException(file, e);
            boolean bl = false;
            return bl;
        }
        catch (ParserConfigurationException e) {
            this.logException(file, e);
            boolean bl = false;
            return bl;
        }
        catch (SAXException e) {
            this.logException(file, e);
            boolean bl = false;
            return bl;
        }
        catch (IOException e) {
            this.logException(file, e);
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (fis != null) {
                    fis.close();
                }
            }
            catch (IOException e) {
                System.out.println("Failed to close FileInputStream : " + e.toString());
            }
        }
    }

    private void logException(File file, Exception e) {
        this.log.error((CharSequence)file.getPath());
        this.log.error((CharSequence)(" --- " + e.toString()));
        this.log.error((CharSequence)"");
    }

    public boolean accept(File arg0, String arg1) {
        return true;
    }
}

