/*
 * Decompiled with CFR 0.152.
 */
package net.tomred.liquibase.validator.stax;

import java.io.File;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.events.XMLEvent;
import net.tomred.liquibase.validator.ValidationResponse;
import net.tomred.liquibase.validator.ValidatorConfiguration;
import net.tomred.liquibase.validator.stax.handler.TagHandler;

public class LiquibaseHandler {
    private final ValidatorConfiguration config;
    private final Set<TagHandler> handlers;
    private final Map<File, List<ValidationResponse>> responses;

    @Inject
    public LiquibaseHandler(ValidatorConfiguration config, Set<TagHandler> handlers) {
        this.config = config;
        this.handlers = handlers;
        this.responses = new HashMap<File, List<ValidationResponse>>();
    }

    public Map<File, List<ValidationResponse>> validate() {
        XMLInputFactory factory = XMLInputFactory.newInstance();
        for (File file : this.config.getFilesToProcess()) {
            try {
                FileInputStream input = new FileInputStream(file);
                XMLEventReader inputEventReader = factory.createXMLEventReader(input);
                while (inputEventReader.hasNext()) {
                    XMLEvent event = inputEventReader.nextEvent();
                    for (TagHandler handler : this.handlers) {
                        ValidationResponse response = handler.handle(event, inputEventReader);
                        this.handleResponse(file, response);
                    }
                }
            }
            catch (Exception e) {
                this.handleResponse(file, new ValidationResponse(ValidationResponse.Level.WARN, e.toString()));
            }
        }
        return this.responses;
    }

    private void handleResponse(File file, ValidationResponse response) {
        if (response != null) {
            List<ValidationResponse> resp = this.responses.get(file);
            if (resp == null) {
                resp = new ArrayList<ValidationResponse>();
            }
            resp.add(response);
            this.responses.put(file, resp);
        }
    }
}

