/*
 * Decompiled with CFR 0.152.
 */
package net.tomred.liquibase.validator.add.column;

import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import net.tomred.liquibase.validator.ValidationResponse;
import net.tomred.liquibase.validator.stax.handler.TagHandler;

public class AddColumnToAuditSchemaWithRemarks
implements TagHandler {
    private static final String TAG_ADDCOLUMN = "addColumn";
    private static final String TAG_COLUMN = "column";
    private static final String ATTR_SCHEMANAME = "schemaName";
    private static final String ATTR_REMARK = "remarks";
    private static final String VALUE_AUDITSCHEMANAME = "${audit.schema.name}";

    @Override
    public ValidationResponse handle(XMLEvent event, XMLEventReader inputEventReader) throws XMLStreamException {
        if (event.isStartElement()) {
            Attribute remarkAttr;
            StartElement startNextElement;
            String startNextElementName;
            XMLEvent nextEvent;
            StartElement startElement = event.asStartElement();
            String startElementName = startElement.getName().getLocalPart();
            Attribute schemaAttr = startElement.getAttributeByName(new QName(ATTR_SCHEMANAME));
            if (startElementName.equals(TAG_ADDCOLUMN) && schemaAttr != null && schemaAttr.getValue().trim().equals(VALUE_AUDITSCHEMANAME) && (nextEvent = inputEventReader.nextTag()).isStartElement() && (startNextElementName = (startNextElement = nextEvent.asStartElement()).getName().getLocalPart()).equals(TAG_COLUMN) && (remarkAttr = startNextElement.getAttributeByName(new QName(ATTR_REMARK))) != null) {
                return new ValidationResponse(ValidationResponse.Level.ERROR, "<column> with remarks cannot be used when <addColumn> has schemaName=\"${audit.schema.name}\"");
            }
        }
        return null;
    }
}

