package net.tomred.liquibase.validator.stax;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

import javax.inject.Inject;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.events.XMLEvent;

import net.tomred.liquibase.validator.ValidationResponse;
import net.tomred.liquibase.validator.ValidationResponse.Level;
import net.tomred.liquibase.validator.ValidatorConfiguration;
import net.tomred.liquibase.validator.stax.handler.TagHandler;

public class LiquibaseHandler {

	private final ValidatorConfiguration config;
	private final Set<TagHandler> handlers;
	private final Map<File, List<ValidationResponse>> responses;

	@Inject
	public LiquibaseHandler(ValidatorConfiguration config, Set<TagHandler> handlers) {
		this.config = config;
		this.handlers = handlers;
		this.responses = new HashMap<File, List<ValidationResponse>>();
	}

	public Map<File, List<ValidationResponse>> validate() {
		XMLInputFactory factory = XMLInputFactory.newInstance();
		for (File file : config.getFilesToProcess()) {
			try {
				InputStream input = new FileInputStream(file);
				XMLEventReader inputEventReader = factory.createXMLEventReader(input);
				while (inputEventReader.hasNext()) {
					XMLEvent event = inputEventReader.nextEvent();
					// loop through the handlers
					for (TagHandler handler : handlers) {
						ValidationResponse response = handler.handle(event, inputEventReader);
						handleResponse(file, response);
					}
				}
			} catch (Exception e) {
				handleResponse(file, new ValidationResponse(Level.WARN, e.toString()));
			}
		}
		return responses;
	}

	private void handleResponse(File file, ValidationResponse response) {
		if (response != null) {
			List<ValidationResponse> resp = responses.get(file);
			if (resp == null) {
				resp = new ArrayList<ValidationResponse>();
			}
			resp.add(response);
			responses.put(file, resp);
		}
	}
}
