package net.tomred.liquibase.validator.global.properties.module;

import net.tomred.liquibase.validator.global.properties.PreventGlobalProperties;
import net.tomred.liquibase.validator.stax.handler.TagHandler;

import com.google.inject.AbstractModule;
import com.google.inject.multibindings.Multibinder;

public class PreventGlobalPropertiesModule extends AbstractModule {

	public static final String module = "prevent-global-properties";

	@Override
	protected void configure() {
		Multibinder<TagHandler> tagHandler = Multibinder.newSetBinder(binder(), TagHandler.class);
		tagHandler.addBinding().to(PreventGlobalProperties.class);
	}

}
