package net.tomred.liquibase.validator.exists.table;

import javax.xml.stream.XMLEventReader;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;

import net.tomred.liquibase.validator.ValidationResponse;
import net.tomred.liquibase.validator.ValidationResponse.Level;
import net.tomred.liquibase.validator.stax.handler.TagHandler;

public class TableExists implements TagHandler {

	private static String TABLEEXISTS = "tableExists";

	@Override
	public ValidationResponse handle(XMLEvent event, XMLEventReader inputEventReader) {
		if (event.isStartElement()) {
			StartElement startElement = event.asStartElement();
			String startElementName = startElement.getName().getLocalPart();
			if (startElementName.equals(TABLEEXISTS)) {
				return new ValidationResponse(Level.ERROR, "<tableExists> is not permitted in liquibase xml files.");
			}
		}
		return null;
	}
}
