package net.tomred.liquibase.validator.exists.column;

import javax.xml.stream.XMLEventReader;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;

import net.tomred.liquibase.validator.ValidationResponse;
import net.tomred.liquibase.validator.ValidationResponse.Level;
import net.tomred.liquibase.validator.stax.handler.TagHandler;

public class ColumnExists implements TagHandler {

	private static String COLUMNEXISTS = "columnExists";

	@Override
	public ValidationResponse handle(XMLEvent event, XMLEventReader inputEventReader) {
		if (event.isStartElement()) {
			StartElement startElement = event.asStartElement();
			String startElementName = startElement.getName().getLocalPart();
			if (startElementName.equals(COLUMNEXISTS)) {
				return new ValidationResponse(Level.ERROR, "<columnExists> is not permitted in liquibase xml files.");
			}
		}
		return null;
	}

}
