package net.tomred.liquibase.validator;

import java.io.File;
import java.util.ArrayList;
import java.util.List;

import javax.inject.Singleton;

import net.tomred.liquibase.validator.utils.FileHandler;
import net.tomred.liquibase.validator.utils.XmlFilenameFilter;

@Singleton
public class ValidatorConfiguration {
	private final File dir;
	private final List<String> ignore;
	private List<File> files = null;

	public ValidatorConfiguration(File dir, List<String> ignore) {
		this.dir = dir;
		this.ignore = ignore == null ? new ArrayList<String>() : ignore;
	}

	public File getBaseDir() {
		return dir;
	}

	public List<String> getFilesToIgnore() {
		return ignore;
	}

	public List<File> getFilesToProcess() {
		if (files == null) {
			files = FileHandler.getLiquibaseFiles(dir, new XmlFilenameFilter(ignore));
		}
		return files;
	}
}
