/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.ui.commons;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractMIMETypesLoader {
    protected static final Logger LOG = LoggerFactory.getLogger(AbstractMIMETypesLoader.class);
    protected static final ObjectMapper MAPPER = new ObjectMapper();
    protected Map<String, String> mimeTypesMap;
    protected List<String> mimeTypes;

    public void load() {
        this.mimeTypesMap = new HashMap<String, String>();
        try {
            JsonNode jsonNode = MAPPER.readTree(this.getMimeTypesFile());
            for (JsonNode node : jsonNode) {
                JsonNode type = node.path("name");
                JsonNode ext = node.path("extension");
                if (type.isMissingNode()) continue;
                this.mimeTypesMap.put(type.asText(), ext.isMissingNode() ? "" : ext.asText());
            }
            this.mimeTypesMap = Collections.unmodifiableMap(this.mimeTypesMap);
            LOG.debug("MIME types loaded: {}", this.mimeTypesMap);
            this.mimeTypes = new ArrayList<String>(this.mimeTypesMap.keySet());
            Collections.sort(this.mimeTypes);
            this.mimeTypes = Collections.unmodifiableList(this.mimeTypes);
        }
        catch (Exception e) {
            LOG.error("Error reading file MIMETypes from resources", (Throwable)e);
        }
    }

    protected abstract String getMimeTypesFile() throws IOException;

    public List<String> getMimeTypes() {
        return this.mimeTypes;
    }

    public String getFileExt(String mimeType) {
        return this.mimeTypesMap.get(mimeType);
    }
}

