/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.enduser.rest;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.client.enduser.rest.AnyTypeRestClient;
import org.apache.syncope.client.enduser.rest.BaseRestClient;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.apache.syncope.common.lib.to.AnyTypeTO;
import org.apache.syncope.common.lib.to.DerSchemaTO;
import org.apache.syncope.common.lib.to.EntityTO;
import org.apache.syncope.common.lib.to.PlainSchemaTO;
import org.apache.syncope.common.lib.to.SchemaTO;
import org.apache.syncope.common.lib.to.VirSchemaTO;
import org.apache.syncope.common.lib.types.AnyTypeKind;
import org.apache.syncope.common.lib.types.SchemaType;
import org.apache.syncope.common.rest.api.beans.SchemaQuery;
import org.apache.syncope.common.rest.api.service.AnyTypeService;
import org.apache.syncope.common.rest.api.service.SchemaService;

public class SchemaRestClient
extends BaseRestClient {
    private static final long serialVersionUID = -2479730152700312373L;

    public static <T extends SchemaTO> List<T> getSchemas(SchemaType schemaType, AnyTypeKind kind) {
        AnyTypeService client = SchemaRestClient.getService(AnyTypeService.class);
        ArrayList classes = new ArrayList();
        switch (kind) {
            case USER: 
            case GROUP: {
                AnyTypeTO type = client.read(kind.name());
                if (type == null) break;
                classes.addAll(type.getClasses());
                break;
            }
            default: {
                AnyTypeRestClient.listAnyTypes().stream().filter(anyTypeTO -> anyTypeTO.getKind() != AnyTypeKind.USER && anyTypeTO.getKind() != AnyTypeKind.GROUP).forEach(anyTypeTO -> classes.addAll(anyTypeTO.getClasses()));
            }
        }
        return SchemaRestClient.getSchemas(schemaType, null, classes.toArray(new String[0]));
    }

    public static <T extends SchemaTO> List<T> getSchemas(SchemaType schemaType, String keyword, String ... anyTypeClasses) {
        SchemaQuery.Builder builder = new SchemaQuery.Builder().type(schemaType);
        if (StringUtils.isNotBlank((CharSequence)keyword)) {
            builder.keyword(keyword);
        }
        if (anyTypeClasses != null && anyTypeClasses.length > 0) {
            builder.anyTypeClasses(anyTypeClasses);
        }
        ArrayList schemas = new ArrayList();
        try {
            schemas.addAll(SchemaRestClient.getService(SchemaService.class).search(builder.build()));
        }
        catch (SyncopeClientException e) {
            LOG.error("While getting all {} schemas for {}", new Object[]{schemaType, anyTypeClasses, e});
        }
        return schemas;
    }

    public static List<String> getSchemaNames(SchemaType schemaType) {
        List<String> schemaNames = Collections.emptyList();
        try {
            schemaNames = SchemaRestClient.getSchemas(schemaType, null, new String[0]).stream().map(EntityTO::getKey).collect(Collectors.toList());
        }
        catch (SyncopeClientException e) {
            LOG.error("While getting all user schema names", (Throwable)e);
        }
        return schemaNames;
    }

    public static List<String> getPlainSchemaNames() {
        return SchemaRestClient.getSchemaNames(SchemaType.PLAIN);
    }

    public static List<String> getDerSchemaNames() {
        return SchemaRestClient.getSchemaNames(SchemaType.DERIVED);
    }

    public static List<String> getVirSchemaNames() {
        return SchemaRestClient.getSchemaNames(SchemaType.VIRTUAL);
    }

    public static PlainSchemaTO read(SchemaType schemaType, String key) {
        return (PlainSchemaTO)SchemaRestClient.getService(SchemaService.class).read(schemaType, key);
    }

    public static void create(SchemaType schemaType, SchemaTO modelObject) {
        SchemaRestClient.getService(SchemaService.class).create(schemaType, modelObject);
    }

    public static void update(SchemaType schemaType, SchemaTO modelObject) {
        SchemaRestClient.getService(SchemaService.class).update(schemaType, modelObject);
    }

    public static PlainSchemaTO deletePlainSchema(String name) {
        PlainSchemaTO response = (PlainSchemaTO)SchemaRestClient.getService(SchemaService.class).read(SchemaType.PLAIN, name);
        SchemaRestClient.getService(SchemaService.class).delete(SchemaType.PLAIN, name);
        return response;
    }

    public static DerSchemaTO deleteDerSchema(String name) {
        DerSchemaTO schemaTO = (DerSchemaTO)SchemaRestClient.getService(SchemaService.class).read(SchemaType.DERIVED, name);
        SchemaRestClient.getService(SchemaService.class).delete(SchemaType.DERIVED, name);
        return schemaTO;
    }

    public static VirSchemaTO deleteVirSchema(String name) {
        VirSchemaTO schemaTO = (VirSchemaTO)SchemaRestClient.getService(SchemaService.class).read(SchemaType.VIRTUAL, name);
        SchemaRestClient.getService(SchemaService.class).delete(SchemaType.VIRTUAL, name);
        return schemaTO;
    }
}

