/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.enduser.panels.any;

import de.agilecoders.wicket.extensions.markup.html.bootstrap.form.password.strength.PasswordStrengthBehavior;
import de.agilecoders.wicket.extensions.markup.html.bootstrap.form.password.strength.PasswordStrengthConfig;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.client.enduser.panels.any.Details;
import org.apache.syncope.client.enduser.rest.RealmRestClient;
import org.apache.syncope.client.ui.commons.ajax.markup.html.LabelInfo;
import org.apache.syncope.client.ui.commons.markup.html.form.AjaxDropDownChoicePanel;
import org.apache.syncope.client.ui.commons.markup.html.form.AjaxTextFieldPanel;
import org.apache.syncope.client.ui.commons.markup.html.form.FieldPanel;
import org.apache.syncope.client.ui.commons.wizards.any.PasswordPanel;
import org.apache.syncope.client.ui.commons.wizards.any.UserWrapper;
import org.apache.syncope.common.lib.to.RealmTO;
import org.apache.syncope.common.lib.to.UserTO;
import org.apache.wicket.Component;
import org.apache.wicket.PageReference;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.model.ResourceModel;

public class UserDetails
extends Details<UserTO> {
    private static final long serialVersionUID = 6592027822510220463L;
    private final FieldPanel<String> realm;
    protected final AjaxTextFieldPanel username;
    protected final UserTO userTO;

    public UserDetails(String id, UserWrapper wrapper, boolean templateMode, boolean includeStatusPanel, PageReference pageRef) {
        super(id, wrapper, templateMode, includeStatusPanel, pageRef);
        this.userTO = (UserTO)wrapper.getInnerObject();
        this.username = new AjaxTextFieldPanel("username", "username", (IModel)new PropertyModel((Object)this.userTO, "username"), false);
        if (wrapper.getPreviousUserTO() != null && StringUtils.compare((String)wrapper.getPreviousUserTO().getUsername(), (String)((UserTO)wrapper.getInnerObject()).getUsername()) != 0) {
            this.username.showExternAction((Component)new LabelInfo("externalAction", wrapper.getPreviousUserTO().getUsername()));
        }
        if (templateMode) {
            this.username.enableJexlHelp();
        } else {
            this.username.addRequiredLabel();
        }
        this.add(new Component[]{this.username});
        this.realm = new AjaxDropDownChoicePanel("destinationRealm", "destinationRealm", (IModel)new PropertyModel((Object)this.userTO, "realm"), false);
        ((AjaxDropDownChoicePanel)this.realm).setChoices(RealmRestClient.list().stream().map(RealmTO::getFullPath).collect(Collectors.toList()));
        this.add(new Component[]{this.realm});
    }

    protected static class EditUserPasswordPanel
    extends Panel {
        private static final long serialVersionUID = -8198836979773590078L;

        protected EditUserPasswordPanel(String id, UserWrapper wrapper, boolean templateMode) {
            super(id);
            this.setOutputMarkupId(true);
            this.add(new Component[]{new Label("warning", (IModel)new ResourceModel("password.change.warning"))});
            this.add(new Component[]{new PasswordPanel("passwordPanel", wrapper, ((UserTO)wrapper.getInnerObject()).getKey() == null, Boolean.valueOf(templateMode), new PasswordStrengthBehavior(new PasswordStrengthConfig().withDebug(false).withShowVerdictsInsideProgressBar(true).withShowProgressBar(true)))});
        }
    }
}

