/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.enduser.panels.any;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.FastDateFormat;
import org.apache.syncope.client.enduser.SyncopeEnduserSession;
import org.apache.syncope.client.enduser.layout.CustomizationOption;
import org.apache.syncope.client.enduser.markup.html.form.BinaryFieldPanel;
import org.apache.syncope.client.enduser.markup.html.form.MultiFieldPanel;
import org.apache.syncope.client.enduser.panels.any.AbstractAttrs;
import org.apache.syncope.client.ui.commons.SchemaUtils;
import org.apache.syncope.client.ui.commons.markup.html.form.AjaxCheckBoxPanel;
import org.apache.syncope.client.ui.commons.markup.html.form.AjaxDateFieldPanel;
import org.apache.syncope.client.ui.commons.markup.html.form.AjaxDateTimeFieldPanel;
import org.apache.syncope.client.ui.commons.markup.html.form.AjaxDropDownChoicePanel;
import org.apache.syncope.client.ui.commons.markup.html.form.AjaxSpinnerFieldPanel;
import org.apache.syncope.client.ui.commons.markup.html.form.AjaxTextFieldPanel;
import org.apache.syncope.client.ui.commons.markup.html.form.EncryptedFieldPanel;
import org.apache.syncope.client.ui.commons.markup.html.form.FieldPanel;
import org.apache.syncope.client.ui.commons.wicket.markup.html.bootstrap.tabs.Accordion;
import org.apache.syncope.client.ui.commons.wizards.any.AnyWrapper;
import org.apache.syncope.client.ui.commons.wizards.any.UserWrapper;
import org.apache.syncope.common.lib.EntityTOUtils;
import org.apache.syncope.common.lib.to.AnyObjectTO;
import org.apache.syncope.common.lib.to.AnyTO;
import org.apache.syncope.common.lib.to.AttrTO;
import org.apache.syncope.common.lib.to.AttributableTO;
import org.apache.syncope.common.lib.to.GroupTO;
import org.apache.syncope.common.lib.to.GroupableRelatableTO;
import org.apache.syncope.common.lib.to.MembershipTO;
import org.apache.syncope.common.lib.to.PlainSchemaTO;
import org.apache.syncope.common.lib.to.UserTO;
import org.apache.syncope.common.lib.types.AttrSchemaType;
import org.apache.syncope.common.lib.types.SchemaType;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.PageReference;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.extensions.markup.html.tabs.AbstractTab;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.IChoiceRenderer;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.model.StringResourceModel;
import org.apache.wicket.model.util.ListModel;

public class PlainAttrs
extends AbstractAttrs<PlainSchemaTO> {
    private static final long serialVersionUID = 552437609667518888L;
    protected final AnyTO previousObject;
    protected String fileKey = "";

    public <T extends AnyTO> PlainAttrs(String id, AnyWrapper<T> modelObject, List<String> anyTypeClasses, Map<String, CustomizationOption> whichPlainAttrs) throws IllegalArgumentException {
        super(id, modelObject, anyTypeClasses, whichPlainAttrs);
        if (modelObject.getInnerObject() instanceof UserTO) {
            this.fileKey = ((UserTO)UserTO.class.cast(modelObject.getInnerObject())).getUsername();
        } else if (modelObject.getInnerObject() instanceof GroupTO) {
            this.fileKey = ((GroupTO)GroupTO.class.cast(modelObject.getInnerObject())).getName();
        } else if (modelObject.getInnerObject() instanceof AnyObjectTO) {
            this.fileKey = ((AnyObjectTO)AnyObjectTO.class.cast(modelObject.getInnerObject())).getName();
        }
        this.previousObject = modelObject instanceof UserWrapper ? ((UserWrapper)UserWrapper.class.cast(modelObject)).getPreviousUserTO() : null;
        this.add(new Component[]{new PlainSchemasOwn("plainSchemas", this.schemas, (IModel<List<AttrTO>>)this.attrs).setOutputMarkupId(true)});
        this.add(new Component[]{new ListView<MembershipTO>("membershipsPlainSchemas", this.membershipTOs){
            private static final long serialVersionUID = 6741044372185745296L;

            protected void populateItem(ListItem<MembershipTO> item) {
                final MembershipTO membershipTO = (MembershipTO)item.getModelObject();
                item.add(new Component[]{new Accordion("membershipPlainSchemas", Collections.singletonList(new AbstractTab((IModel)new StringResourceModel("attributes.membership.accordion", (Component)PlainAttrs.this, (IModel)Model.of((Serializable)membershipTO))){
                    private static final long serialVersionUID = 1037272333056449378L;

                    public WebMarkupContainer getPanel(String panelId) {
                        return new PlainSchemasMemberships(panelId, membershipTO.getGroupName(), (Map)PlainAttrs.this.membershipSchemas.get(membershipTO.getGroupKey()), (IModel<AttributableTO>)new LoadableDetachableModel<AttributableTO>(){
                            private static final long serialVersionUID = 526768546610546553L;

                            protected AttributableTO load() {
                                return membershipTO;
                            }
                        });
                    }
                }), (IModel)Model.of((Serializable)Integer.valueOf(-1))).setOutputMarkupId(true)});
            }
        }});
    }

    @Override
    protected SchemaType getSchemaType() {
        return SchemaType.PLAIN;
    }

    @Override
    protected boolean filterSchemas() {
        return super.filterSchemas();
    }

    @Override
    protected List<AttrTO> getAttrsFromTO() {
        return this.anyTO.getPlainAttrs().stream().sorted(this.attrComparator).collect(Collectors.toList());
    }

    @Override
    protected List<AttrTO> getAttrsFromTO(MembershipTO membershipTO) {
        return membershipTO.getPlainAttrs().stream().sorted(this.attrComparator).collect(Collectors.toList());
    }

    @Override
    protected void setAttrs() {
        ArrayList attrs = new ArrayList();
        Map attrMap = EntityTOUtils.buildAttrMap((Collection)this.anyTO.getPlainAttrs());
        attrs.addAll(this.schemas.values().stream().map(schema -> {
            AttrTO attrTO = new AttrTO();
            attrTO.setSchema(schema.getKey());
            if (attrMap.get(schema.getKey()) == null || ((AttrTO)attrMap.get(schema.getKey())).getValues().isEmpty()) {
                attrTO.getValues().add("");
            } else {
                attrTO = (AttrTO)attrMap.get(schema.getKey());
            }
            return attrTO;
        }).collect(Collectors.toList()));
        this.anyTO.getPlainAttrs().clear();
        this.anyTO.getPlainAttrs().addAll(attrs);
    }

    @Override
    protected void setAttrs(MembershipTO membershipTO) {
        ArrayList plainAttrs = new ArrayList();
        Map attrMap = ((GroupableRelatableTO)GroupableRelatableTO.class.cast(this.anyTO)).getMembership(membershipTO.getGroupKey()).isPresent() ? EntityTOUtils.buildAttrMap((Collection)((MembershipTO)((GroupableRelatableTO)GroupableRelatableTO.class.cast(this.anyTO)).getMembership(membershipTO.getGroupKey()).get()).getPlainAttrs()) : new HashMap();
        plainAttrs.addAll(((Map)this.membershipSchemas.get(membershipTO.getGroupKey())).values().stream().map(schema -> {
            AttrTO attrTO = new AttrTO();
            attrTO.setSchema(schema.getKey());
            if (attrMap.get(schema.getKey()) == null || ((AttrTO)attrMap.get(schema.getKey())).getValues().isEmpty()) {
                attrTO.getValues().add("");
            } else {
                attrTO.getValues().addAll(((AttrTO)attrMap.get(schema.getKey())).getValues());
            }
            return attrTO;
        }).collect(Collectors.toList()));
        membershipTO.getPlainAttrs().clear();
        membershipTO.getPlainAttrs().addAll(plainAttrs);
    }

    protected FieldPanel getFieldPanel(PlainSchemaTO schemaTO) {
        return this.getFieldPanel(schemaTO, null);
    }

    protected FieldPanel getFieldPanel(final PlainSchemaTO schemaTO, String groupName) {
        Object panel;
        boolean required = schemaTO.getMandatoryCondition().equalsIgnoreCase("true");
        boolean readOnly = schemaTO.isReadonly() || this.renderAsReadonly(schemaTO.getKey(), groupName);
        AttrSchemaType type = schemaTO.getType();
        boolean jexlHelp = false;
        switch (type) {
            case Boolean: {
                panel = new AjaxCheckBoxPanel("panel", schemaTO.getLabel(this.getLocale()), (IModel)new Model(), true);
                panel.setRequired(required);
                break;
            }
            case Date: {
                String datePattern = schemaTO.getConversionPattern() == null ? "yyyy-MM-dd'T'HH:mm:ssZ" : schemaTO.getConversionPattern();
                panel = datePattern.contains("H") ? new AjaxDateTimeFieldPanel("panel", schemaTO.getLabel(this.getLocale()), (IModel)new Model(), FastDateFormat.getInstance((String)datePattern)) : new AjaxDateFieldPanel("panel", schemaTO.getLabel(this.getLocale()), (IModel)new Model(), FastDateFormat.getInstance((String)datePattern));
                if (!required) break;
                panel.addRequiredLabel();
                break;
            }
            case Enum: {
                panel = new AjaxDropDownChoicePanel("panel", schemaTO.getLabel(this.getLocale()), (IModel)new Model(), true);
                ((AjaxDropDownChoicePanel)panel).setChoices(SchemaUtils.getEnumeratedValues((PlainSchemaTO)schemaTO));
                if (StringUtils.isNotBlank((CharSequence)schemaTO.getEnumerationKeys())) {
                    ((AjaxDropDownChoicePanel)panel).setChoiceRenderer((IChoiceRenderer)new IChoiceRenderer<String>(){
                        private static final long serialVersionUID = -3724971416312135885L;
                        private final Map<String, String> valueMap;
                        {
                            this.valueMap = SchemaUtils.getEnumeratedKeyValues((PlainSchemaTO)schemaTO);
                        }

                        public String getDisplayValue(String value) {
                            return this.valueMap.get(value) == null ? value : this.valueMap.get(value);
                        }

                        public String getIdValue(String value, int i) {
                            return value;
                        }

                        public String getObject(String id, IModel<? extends List<? extends String>> choices) {
                            return id;
                        }
                    });
                }
                if (!required) break;
                panel.addRequiredLabel();
                break;
            }
            case Long: {
                panel = new AjaxSpinnerFieldPanel.Builder().enableOnChange().build("panel", schemaTO.getLabel(this.getLocale()), Long.class, (IModel)new Model());
                if (!required) break;
                panel.addRequiredLabel();
                break;
            }
            case Double: {
                panel = new AjaxSpinnerFieldPanel.Builder().enableOnChange().step((Number)0.1).build("panel", schemaTO.getLabel(this.getLocale()), Double.class, (IModel)new Model());
                if (!required) break;
                panel.addRequiredLabel();
                break;
            }
            case Binary: {
                final PageReference pageRef = this.getPageReference();
                panel = new BinaryFieldPanel("panel", schemaTO.getLabel(this.getLocale()), (IModel)new Model(), schemaTO.getMimeType(), this.fileKey){
                    private static final long serialVersionUID = -3268213909514986831L;

                    protected PageReference getPageReference() {
                        return pageRef;
                    }
                };
                if (!required) break;
                panel.addRequiredLabel();
                break;
            }
            case Encrypted: {
                panel = new EncryptedFieldPanel("panel", schemaTO.getLabel(this.getLocale()), (IModel)new Model(), true);
                if (!required) break;
                panel.addRequiredLabel();
                break;
            }
            default: {
                panel = new AjaxTextFieldPanel("panel", schemaTO.getLabel(this.getLocale()), (IModel)new Model(), true);
                if (!required) break;
                panel.addRequiredLabel();
            }
        }
        panel.setReadOnly(readOnly);
        panel.setMarkupId(StringUtils.isBlank((CharSequence)groupName) ? schemaTO.getKey() : groupName + '.' + schemaTO.getKey());
        panel.setInputTitle(schemaTO.getLabel(SyncopeEnduserSession.get().getLocale()));
        panel.setFormComponentId("form_" + (StringUtils.isBlank((CharSequence)groupName) ? schemaTO.getKey() : groupName + '.' + schemaTO.getKey()));
        Label label = (Label)panel.get("field-label");
        label.add(new Behavior[]{new AttributeModifier("for", (Serializable)((Object)("form_" + (StringUtils.isBlank((CharSequence)groupName) ? schemaTO.getKey() : groupName + '.' + schemaTO.getKey()))))});
        return panel;
    }

    protected class PlainSchemasOwn
    extends AbstractAttrs.Schemas {
        private static final long serialVersionUID = -4730563859116024676L;

        public PlainSchemasOwn(String id, final Map<String, PlainSchemaTO> schemas, IModel<List<AttrTO>> attrTOs) {
            super(id);
            this.add(new Component[]{new ListView<AttrTO>("schemas", attrTOs){
                private static final long serialVersionUID = 9101744072914090143L;

                protected void populateItem(ListItem<AttrTO> item) {
                    AttrTO attrTO = (AttrTO)item.getModelObject();
                    PlainSchemaTO schema = (PlainSchemaTO)schemas.get(attrTO.getSchema());
                    if (attrTO.getValues().stream().noneMatch(StringUtils::isNotBlank)) {
                        attrTO.getValues().clear();
                        attrTO.getValues().addAll(PlainAttrs.this.getDefaultValues(attrTO.getSchema()));
                    }
                    Object panel = PlainAttrs.this.getFieldPanel((PlainSchemaTO)schemas.get(attrTO.getSchema()));
                    if (((PlainSchemaTO)schemas.get(attrTO.getSchema())).isMultivalue()) {
                        panel = new MultiFieldPanel.Builder(new PropertyModel((Object)attrTO, "values")).build("panel", attrTO.getSchema(), (FieldPanel)FieldPanel.class.cast(panel));
                        ((MultiFieldPanel)((Object)panel)).setReadOnly(schema == null ? false : schema.isReadonly());
                    } else {
                        ((FieldPanel)FieldPanel.class.cast(panel)).setNewModel(attrTO.getValues()).setReadOnly(schema == null ? false : schema.isReadonly());
                    }
                    item.add(new Component[]{panel});
                }
            }});
        }
    }

    protected class PlainSchemasMemberships
    extends AbstractAttrs.Schemas {
        private static final long serialVersionUID = 456754923340249215L;

        public PlainSchemasMemberships(String id, final String groupName, final Map<String, PlainSchemaTO> schemas, final IModel<AttributableTO> attributableTO) {
            super(id);
            this.add(new Component[]{new ListView<AttrTO>("schemas", (IModel)new ListModel(new ArrayList(((AttributableTO)attributableTO.getObject()).getPlainAttrs().stream().sorted(PlainAttrs.this.attrComparator).collect(Collectors.toList())))){
                private static final long serialVersionUID = 5306618783986001008L;

                protected void populateItem(ListItem<AttrTO> item) {
                    AttrTO attrTO = (AttrTO)item.getModelObject();
                    PlainSchemaTO schema = (PlainSchemaTO)schemas.get(attrTO.getSchema());
                    if (attrTO.getValues().stream().noneMatch(StringUtils::isNotBlank)) {
                        attrTO.getValues().clear();
                        attrTO.getValues().addAll(PlainAttrs.this.getDefaultValues(attrTO.getSchema(), groupName));
                    }
                    Object panel = PlainAttrs.this.getFieldPanel((PlainSchemaTO)schemas.get(attrTO.getSchema()));
                    if (((PlainSchemaTO)schemas.get(attrTO.getSchema())).isMultivalue()) {
                        panel = new MultiFieldPanel.Builder(new PropertyModel((Object)((AttributableTO)attributableTO.getObject()).getPlainAttr(attrTO.getSchema()), "values")).build("panel", attrTO.getSchema(), (FieldPanel)FieldPanel.class.cast(panel));
                        ((MultiFieldPanel)((Object)panel)).setReadOnly(schema == null ? false : schema.isReadonly());
                    } else {
                        ((FieldPanel)FieldPanel.class.cast(panel)).setNewModel(attrTO.getValues()).setReadOnly(schema == null ? false : schema.isReadonly());
                    }
                    item.add(new Component[]{panel});
                }
            }});
        }
    }
}

